/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.util.List;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.PercentileDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.PercentileIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.PercentileLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.expression.function.aggregate.NumericAggregate;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class Percentile
extends NumericAggregate {
    private final Expression percentile;

    public Percentile(Source source, Expression field, Expression percentile) {
        super(source, field, List.of(percentile));
        this.percentile = percentile;
    }

    protected NodeInfo<Percentile> info() {
        return NodeInfo.create((Node)this, Percentile::new, (Object)this.field(), (Object)this.percentile);
    }

    public Percentile replaceChildren(List<Expression> newChildren) {
        return new Percentile(this.source(), newChildren.get(0), newChildren.get(1));
    }

    public Expression percentile() {
        return this.percentile;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isNumeric((Expression)this.field(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isNumeric((Expression)this.percentile, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND).and(TypeResolutions.isFoldable((Expression)this.percentile, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND));
    }

    @Override
    protected AggregatorFunctionSupplier longSupplier(BigArrays bigArrays, List<Integer> inputChannels) {
        return new PercentileLongAggregatorFunctionSupplier(bigArrays, inputChannels, (double)this.percentileValue());
    }

    @Override
    protected AggregatorFunctionSupplier intSupplier(BigArrays bigArrays, List<Integer> inputChannels) {
        return new PercentileIntAggregatorFunctionSupplier(bigArrays, inputChannels, (double)this.percentileValue());
    }

    @Override
    protected AggregatorFunctionSupplier doubleSupplier(BigArrays bigArrays, List<Integer> inputChannels) {
        return new PercentileDoubleAggregatorFunctionSupplier(bigArrays, inputChannels, (double)this.percentileValue());
    }

    private int percentileValue() {
        return ((Number)this.percentile.fold()).intValue();
    }
}

