/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanArrayBlock;
import org.elasticsearch.compute.data.BooleanArrayVector;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.evaluator.mapper.ExpressionMapper;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.ComparisonMapper;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.esql.planner.Layout;
import org.elasticsearch.xpack.ql.expression.Expression;

public class InMapper
extends ExpressionMapper<In> {
    public static final InMapper IN_MAPPER = new InMapper();

    private InMapper() {
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory map(In in, Layout layout) {
        ArrayList listEvaluators = new ArrayList(in.list().size());
        in.list().forEach(e -> {
            Equals eq = new Equals(in.source(), in.value(), (Expression)e);
            EvalOperator.ExpressionEvaluator.Factory eqEvaluator = ComparisonMapper.EQUALS.map(eq, layout);
            listEvaluators.add(eqEvaluator);
        });
        return dvrCtx -> new InExpressionEvaluator(listEvaluators.stream().map(fac -> fac.get(dvrCtx)).toList());
    }

    record InExpressionEvaluator(List<EvalOperator.ExpressionEvaluator> listEvaluators) implements EvalOperator.ExpressionEvaluator
    {
        public Block eval(Page page) {
            int positionCount = page.getPositionCount();
            boolean[] values = new boolean[positionCount];
            BitSet nulls = new BitSet(positionCount);
            boolean nullInValues = false;
            for (int i = 0; i < this.listEvaluators().size(); ++i) {
                EvalOperator.ExpressionEvaluator evaluator = this.listEvaluators.get(i);
                try (BooleanBlock block = (BooleanBlock)evaluator.eval(page);){
                    BooleanVector vector = block.asVector();
                    if (vector != null) {
                        InExpressionEvaluator.updateValues(vector, values);
                        continue;
                    }
                    if (block.areAllValuesNull()) {
                        nullInValues = true;
                        continue;
                    }
                    InExpressionEvaluator.updateValues(block, values, nulls);
                    continue;
                }
            }
            return InExpressionEvaluator.evalWithNulls(values, nulls, nullInValues);
        }

        private static void updateValues(BooleanVector vector, boolean[] values) {
            for (int p = 0; p < values.length; ++p) {
                int n = p;
                values[n] = values[n] | vector.getBoolean(p);
            }
        }

        private static void updateValues(BooleanBlock block, boolean[] values, BitSet nulls) {
            block0: for (int p = 0; p < values.length; ++p) {
                if (block.isNull(p)) {
                    nulls.set(p);
                    continue;
                }
                int start = block.getFirstValueIndex(p);
                int end = start + block.getValueCount(p);
                for (int i = start; i < end; ++i) {
                    if (!block.getBoolean(i)) continue;
                    values[p] = true;
                    continue block0;
                }
            }
        }

        private static Block evalWithNulls(boolean[] values, BitSet nulls, boolean nullInValues) {
            if (nulls.isEmpty() && !nullInValues) {
                return new BooleanArrayVector(values, values.length).asBlock();
            }
            for (int i = 0; i < values.length; ++i) {
                if (values[i]) {
                    nulls.clear(i);
                    continue;
                }
                if (!nullInValues) continue;
                nulls.set(i);
            }
            if (nulls.isEmpty()) {
                return new BooleanArrayVector(values, values.length).asBlock();
            }
            return new BooleanArrayBlock(values, values.length, null, nulls, Block.MvOrdering.UNORDERED);
        }

        public void close() {
            Releasables.closeExpectNoException(() -> Releasables.close(this.listEvaluators));
        }
    }
}

