/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.compute.OwningChannelActionListener;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.enrich.EnrichMetadata;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.esql.enrich.EnrichPolicyResolution;
import org.elasticsearch.xpack.esql.session.EsqlSession;
import org.elasticsearch.xpack.ql.index.IndexResolution;
import org.elasticsearch.xpack.ql.index.IndexResolver;

public class EnrichPolicyResolver {
    private static final String RESOLVE_ACTION_NAME = "cluster:monitor/xpack/enrich/esql/resolve_policy";
    private final ClusterService clusterService;
    private final IndexResolver indexResolver;
    private final TransportService transportService;
    private final ThreadPool threadPool;

    public EnrichPolicyResolver(ClusterService clusterService, TransportService transportService, IndexResolver indexResolver) {
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.indexResolver = indexResolver;
        this.threadPool = transportService.getThreadPool();
        transportService.registerRequestHandler(RESOLVE_ACTION_NAME, (Executor)this.threadPool.executor("esql"), ResolveRequest::new, (TransportRequestHandler)new RequestHandler());
    }

    public void resolvePolicy(String policyName, ActionListener<EnrichPolicyResolution> listener) {
        this.transportService.sendRequest(this.clusterService.localNode(), RESOLVE_ACTION_NAME, (TransportRequest)new ResolveRequest(policyName), (TransportResponseHandler)new ActionListenerResponseHandler(listener.map(r -> r.resolution), ResolveResponse::new, (Executor)this.threadPool.executor("esql")));
    }

    private static UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException("local node transport action");
    }

    public Set<String> allPolicyNames() {
        return this.policies().keySet();
    }

    private Map<String, EnrichPolicy> policies() {
        if (this.clusterService == null || this.clusterService.state() == null) {
            return Map.of();
        }
        EnrichMetadata metadata = (EnrichMetadata)this.clusterService.state().metadata().custom("enrich");
        return metadata == null ? Map.of() : metadata.getPolicies();
    }

    private class RequestHandler
    implements TransportRequestHandler<ResolveRequest> {
        private RequestHandler() {
        }

        public void messageReceived(ResolveRequest request, TransportChannel channel, Task task) throws Exception {
            String policyName = request.policyName;
            EnrichPolicy policy = EnrichPolicyResolver.this.policies().get(policyName);
            ThreadContext threadContext = EnrichPolicyResolver.this.threadPool.getThreadContext();
            OwningChannelActionListener listener = new OwningChannelActionListener(channel);
            listener = ContextPreservingActionListener.wrapPreservingContext((ActionListener)listener, (ThreadContext)threadContext);
            try (ThreadContext.StoredContext ignored = threadContext.stashWithOrigin("enrich");){
                EnrichPolicyResolver.this.indexResolver.resolveAsMergedMapping(EnrichPolicy.getBaseName((String)policyName), IndexResolver.ALL_FIELDS, false, Map.of(), listener.map(indexResult -> new ResolveResponse(new EnrichPolicyResolution(policyName, policy, (IndexResolution)indexResult))), EsqlSession::specificValidity);
            }
        }
    }

    private static class ResolveRequest
    extends TransportRequest {
        private final String policyName;

        ResolveRequest(String policyName) {
            this.policyName = policyName;
        }

        ResolveRequest(StreamInput in) {
            throw EnrichPolicyResolver.unsupported();
        }

        public void writeTo(StreamOutput out) {
            throw EnrichPolicyResolver.unsupported();
        }
    }

    private static class ResolveResponse
    extends TransportResponse {
        private final EnrichPolicyResolution resolution;

        ResolveResponse(EnrichPolicyResolution resolution) {
            this.resolution = resolution;
        }

        ResolveResponse(StreamInput in) {
            throw EnrichPolicyResolver.unsupported();
        }

        public void writeTo(StreamOutput out) {
            throw EnrichPolicyResolver.unsupported();
        }
    }
}

