/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.analysis;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.esql.analysis.AnalyzerContext;
import org.elasticsearch.xpack.esql.analysis.EnrichResolution;
import org.elasticsearch.xpack.esql.analysis.VerificationException;
import org.elasticsearch.xpack.esql.analysis.Verifier;
import org.elasticsearch.xpack.esql.enrich.EnrichPolicyResolution;
import org.elasticsearch.xpack.esql.expression.function.UnsupportedAttribute;
import org.elasticsearch.xpack.esql.plan.logical.Drop;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.EsqlUnresolvedRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Keep;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.Rename;
import org.elasticsearch.xpack.esql.plan.logical.local.EsqlProject;
import org.elasticsearch.xpack.esql.stats.FeatureMetric;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.analyzer.AnalyzerRules;
import org.elasticsearch.xpack.ql.common.Failure;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.EmptyAttribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.ReferenceAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedStar;
import org.elasticsearch.xpack.ql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.ql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.index.EsIndex;
import org.elasticsearch.xpack.ql.index.IndexResolution;
import org.elasticsearch.xpack.ql.plan.TableIdentifier;
import org.elasticsearch.xpack.ql.plan.logical.Aggregate;
import org.elasticsearch.xpack.ql.plan.logical.EsRelation;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.Project;
import org.elasticsearch.xpack.ql.rule.ParameterizedRule;
import org.elasticsearch.xpack.ql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.EsField;
import org.elasticsearch.xpack.ql.type.InvalidMappedField;
import org.elasticsearch.xpack.ql.type.UnsupportedEsField;
import org.elasticsearch.xpack.ql.util.CollectionUtils;
import org.elasticsearch.xpack.ql.util.StringUtils;

public class Analyzer
extends ParameterizedRuleExecutor<LogicalPlan, AnalyzerContext> {
    static final List<Attribute> NO_FIELDS = List.of(new ReferenceAttribute(Source.EMPTY, "<no-fields>", DataTypes.NULL, null, Nullability.TRUE, null, false));
    private static final Iterable<RuleExecutor.Batch<LogicalPlan>> rules;
    private final Verifier verifier;

    public Analyzer(AnalyzerContext context, Verifier verifier) {
        super((Object)context);
        this.verifier = verifier;
    }

    public LogicalPlan analyze(LogicalPlan plan) {
        BitSet partialMetrics = new BitSet(FeatureMetric.values().length);
        return this.verify((LogicalPlan)this.execute((Node)plan), this.gatherPreAnalysisMetrics(plan, partialMetrics));
    }

    public LogicalPlan verify(LogicalPlan plan, BitSet partialMetrics) {
        Collection<Failure> failures = this.verifier.verify(plan, partialMetrics);
        if (!failures.isEmpty()) {
            throw new VerificationException(failures);
        }
        return plan;
    }

    protected Iterable<RuleExecutor.Batch<LogicalPlan>> batches() {
        return rules;
    }

    private static List<Attribute> mappingAsAttributes(Source source, Map<String, EsField> mapping) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        Analyzer.mappingAsAttributes(list, source, null, mapping);
        list.sort(Comparator.comparing(Attribute::qualifiedName));
        return list;
    }

    private static void mappingAsAttributes(List<Attribute> list, Source source, String parentName, Map<String, EsField> mapping) {
        for (Map.Entry<String, EsField> entry : mapping.entrySet()) {
            String name = entry.getKey();
            EsField t = entry.getValue();
            if (t == null) continue;
            name = parentName == null ? name : parentName + "." + name;
            Map fieldProperties = t.getProperties();
            DataType type = EsqlDataTypes.widenSmallNumericTypes(t.getDataType());
            if (type != t.getDataType()) {
                t = new EsField(t.getName(), type, t.getProperties(), t.isAggregatable(), t.isAlias());
            }
            if (EsqlDataTypes.isPrimitive(type)) {
                FieldAttribute attribute;
                if (t instanceof UnsupportedEsField) {
                    UnsupportedEsField uef = (UnsupportedEsField)t;
                    attribute = new UnsupportedAttribute(source, name, uef);
                } else {
                    attribute = new FieldAttribute(source, null, name, t);
                }
                list.add((Attribute)attribute);
            }
            if (type == DataTypes.NESTED || fieldProperties.isEmpty()) continue;
            Analyzer.mappingAsAttributes(list, source, name, fieldProperties);
        }
    }

    private static List<Attribute> resolveAgainstList(UnresolvedAttribute u, Collection<Attribute> attrList) {
        List matches = AnalyzerRules.maybeResolveAgainstList((UnresolvedAttribute)u, attrList, (boolean)false, (boolean)true, Analyzer::handleSpecialFields);
        if (matches.isEmpty()) {
            UnresolvedAttribute unresolved;
            String name = u.name();
            if (Regex.isSimpleMatchPattern((String)name)) {
                unresolved = u.withUnresolvedMessage(LoggerMessageFormat.format(null, (String)"No match found for [{}]", (Object[])new Object[]{name}));
            } else {
                HashSet<String> names = new HashSet<String>(attrList.size());
                for (Attribute a : attrList) {
                    String nameCandidate = a.name();
                    if (!EsqlDataTypes.isPrimitive(a.dataType())) continue;
                    names.add(nameCandidate);
                }
                unresolved = u.withUnresolvedMessage(UnresolvedAttribute.errorMessage((String)name, (List)StringUtils.findSimilar((String)name, names)));
            }
            return Collections.singletonList(unresolved);
        }
        return matches;
    }

    private static Attribute handleSpecialFields(UnresolvedAttribute u, Attribute named) {
        FieldAttribute fa;
        EsField field;
        if (named instanceof FieldAttribute && (field = (fa = (FieldAttribute)named).field()) instanceof InvalidMappedField) {
            InvalidMappedField imf = (InvalidMappedField)field;
            named = u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] due to ambiguities being " + imf.errorMessage());
        }
        return named;
    }

    private BitSet gatherPreAnalysisMetrics(LogicalPlan plan, BitSet b) {
        if (!plan.collectFirstChildren(Limit.class::isInstance).isEmpty()) {
            b.set(FeatureMetric.LIMIT.ordinal());
        }
        plan.forEachDown(p -> FeatureMetric.set(p, b));
        return b;
    }

    static {
        RuleExecutor.Batch resolution = new RuleExecutor.Batch("Resolution", new Rule[]{new ResolveTable(), new ResolveEnrich(), new ResolveRefs(), new ResolveFunctions(), new RemoveDuplicateProjections()});
        RuleExecutor.Batch finish = new RuleExecutor.Batch("Finish Analysis", RuleExecutor.Limiter.ONCE, new Rule[]{new AddImplicitLimit(), new PromoteStringsInDateComparisons()});
        rules = List.of(resolution, finish);
    }

    private static class ResolveTable
    extends AnalyzerRules.ParameterizedAnalyzerRule<EsqlUnresolvedRelation, AnalyzerContext> {
        private ResolveTable() {
        }

        protected LogicalPlan rule(EsqlUnresolvedRelation plan, AnalyzerContext context) {
            if (!context.indexResolution().isValid()) {
                return plan.unresolvedMessage().equals(context.indexResolution().toString()) ? plan : new EsqlUnresolvedRelation(plan.source(), plan.table(), plan.metadataFields(), context.indexResolution().toString());
            }
            TableIdentifier table = plan.table();
            if (!context.indexResolution().matches(table.index())) {
                new EsqlUnresolvedRelation(plan.source(), plan.table(), plan.metadataFields(), "invalid [" + table + "] resolution to [" + context.indexResolution() + "]");
            }
            EsIndex esIndex = context.indexResolution().get();
            List<Attribute> attributes = Analyzer.mappingAsAttributes(plan.source(), esIndex.mapping());
            attributes.addAll(plan.metadataFields());
            return new EsRelation(plan.source(), esIndex, attributes.isEmpty() ? NO_FIELDS : attributes);
        }
    }

    private static class ResolveEnrich
    extends AnalyzerRules.ParameterizedAnalyzerRule<Enrich, AnalyzerContext> {
        private ResolveEnrich() {
        }

        protected LogicalPlan rule(Enrich plan, AnalyzerContext context) {
            NamedExpression matchField;
            if (!plan.policyName().resolved()) {
                return plan;
            }
            String policyName = (String)plan.policyName().fold();
            EnrichPolicyResolution policyRes = context.enrichResolution().resolvedPolicies().stream().filter(x -> x.policyName().equals(policyName)).findFirst().orElse(new EnrichPolicyResolution(policyName, null, null));
            IndexResolution idx = policyRes.index();
            EnrichPolicy policy = policyRes.policy();
            UnresolvedAttribute policyNameExp = policy == null || idx == null ? new UnresolvedAttribute(plan.policyName().source(), policyName, null, this.unresolvedPolicyError(policyName, context.enrichResolution())) : plan.policyName();
            Object object = matchField = policy != null && (plan.matchField() == null || plan.matchField() instanceof EmptyAttribute) ? new UnresolvedAttribute(plan.source(), policy.getMatchField()) : plan.matchField();
            List<NamedExpression> enrichFields = policy == null || idx == null ? (plan.enrichFields() == null ? List.of() : plan.enrichFields()) : ResolveEnrich.calculateEnrichFields(plan.source(), policyName, Analyzer.mappingAsAttributes(plan.source(), idx.get().mapping()), plan.enrichFields(), policy);
            return new Enrich(plan.source(), plan.child(), (Expression)policyNameExp, matchField, policyRes, enrichFields);
        }

        private String unresolvedPolicyError(String policyName, EnrichResolution enrichResolution) {
            List potentialMatches = StringUtils.findSimilar((String)policyName, enrichResolution.existingPolicies());
            String msg = "unresolved enrich policy [" + policyName + "]";
            if (!CollectionUtils.isEmpty((Collection)potentialMatches)) {
                msg = msg + ", did you mean " + (potentialMatches.size() == 1 ? "[" + (String)potentialMatches.get(0) + "]" : "any of " + potentialMatches) + "?";
            }
            return msg;
        }

        public static List<NamedExpression> calculateEnrichFields(Source source, String policyName, List<Attribute> mapping, List<NamedExpression> enrichFields, EnrichPolicy policy) {
            HashSet policyEnrichFieldSet = new HashSet(policy.getEnrichFields());
            Map<String, Attribute> fieldMap = mapping.stream().filter(e -> policyEnrichFieldSet.contains(e.name())).collect(Collectors.toMap(NamedExpression::name, Function.identity()));
            ArrayList<NamedExpression> result = new ArrayList<NamedExpression>();
            if (enrichFields == null || enrichFields.isEmpty()) {
                for (String enrichFieldName : policy.getEnrichFields()) {
                    result.add(ResolveEnrich.createEnrichFieldExpression(source, policyName, fieldMap, enrichFieldName));
                }
            } else {
                for (NamedExpression enrichField : enrichFields) {
                    NamedExpression namedExpression;
                    NamedExpression namedExpression2;
                    if (enrichField instanceof Alias) {
                        Alias a = (Alias)enrichField;
                        namedExpression2 = a.child();
                    } else {
                        namedExpression2 = enrichField;
                    }
                    String enrichFieldName = Expressions.name((Expression)namedExpression2);
                    NamedExpression field = ResolveEnrich.createEnrichFieldExpression(source, policyName, fieldMap, enrichFieldName);
                    if (enrichField instanceof Alias) {
                        Alias a = (Alias)enrichField;
                        namedExpression = new Alias(a.source(), a.name(), (Expression)field);
                    } else {
                        namedExpression = field;
                    }
                    result.add(namedExpression);
                }
            }
            return result;
        }

        private static NamedExpression createEnrichFieldExpression(Source source, String policyName, Map<String, Attribute> fieldMap, String enrichFieldName) {
            Attribute mappedField = fieldMap.get(enrichFieldName);
            if (mappedField == null) {
                String msg = "Enrich field [" + enrichFieldName + "] not found in enrich policy [" + policyName + "]";
                List similar = StringUtils.findSimilar((String)enrichFieldName, fieldMap.keySet());
                if (!CollectionUtils.isEmpty((Collection)similar)) {
                    msg = msg + ", did you mean " + (similar.size() == 1 ? "[" + (String)similar.get(0) + "]" : "any of " + similar) + "?";
                }
                return new UnresolvedAttribute(source, enrichFieldName, null, msg);
            }
            return new ReferenceAttribute(source, enrichFieldName, mappedField.dataType(), null, Nullability.TRUE, null, false);
        }
    }

    private static class ResolveRefs
    extends AnalyzerRules.BaseAnalyzerRule {
        private ResolveRefs() {
        }

        protected LogicalPlan doRule(LogicalPlan plan) {
            Object p;
            ArrayList<Attribute> childrenOutput = new ArrayList<Attribute>();
            for (LogicalPlan child : plan.children()) {
                List output = child.output();
                childrenOutput.addAll(output);
            }
            if (plan instanceof Drop) {
                Drop d = (Drop)plan;
                return this.resolveDrop(d, childrenOutput);
            }
            if (plan instanceof Rename) {
                Rename r = (Rename)plan;
                return this.resolveRename(r, childrenOutput);
            }
            if (plan instanceof Keep) {
                p = (Keep)plan;
                return this.resolveKeep((Project)p, (List<Attribute>)childrenOutput);
            }
            if (plan instanceof Eval) {
                p = (Eval)plan;
                return this.resolveEval((Eval)((Object)p), childrenOutput);
            }
            if (plan instanceof Enrich) {
                p = (Enrich)plan;
                return this.resolveEnrich((Enrich)((Object)p), childrenOutput);
            }
            if (plan instanceof MvExpand) {
                p = (MvExpand)plan;
                return this.resolveMvExpand((MvExpand)((Object)p), childrenOutput);
            }
            return (LogicalPlan)plan.transformExpressionsUp(UnresolvedAttribute.class, ua -> this.maybeResolveAttribute((UnresolvedAttribute)ua, (List<Attribute>)childrenOutput));
        }

        private LogicalPlan resolveMvExpand(MvExpand p, List<Attribute> childrenOutput) {
            NamedExpression namedExpression = p.target();
            if (namedExpression instanceof UnresolvedAttribute) {
                UnresolvedAttribute ua = (UnresolvedAttribute)namedExpression;
                Attribute resolved = this.maybeResolveAttribute(ua, childrenOutput);
                if (resolved == ua) {
                    return p;
                }
                return new MvExpand(p.source(), p.child(), (NamedExpression)resolved, (Attribute)(resolved.resolved() ? new ReferenceAttribute(resolved.source(), resolved.name(), resolved.dataType(), null, resolved.nullable(), null, false) : resolved));
            }
            return p;
        }

        private Attribute maybeResolveAttribute(UnresolvedAttribute ua, List<Attribute> childrenOutput) {
            if (ua.customMessage()) {
                return ua;
            }
            return this.resolveAttribute(ua, childrenOutput);
        }

        private Attribute resolveAttribute(UnresolvedAttribute ua, List<Attribute> childrenOutput) {
            UnresolvedAttribute resolved = ua;
            List<Attribute> named = Analyzer.resolveAgainstList(ua, childrenOutput);
            if (named.size() == 1) {
                resolved = named.get(0);
                if (this.log.isTraceEnabled() && resolved.resolved()) {
                    this.log.trace("Resolved {} to {}", (Object)ua, (Object)resolved);
                }
            } else if (named.size() > 0) {
                resolved = ua.withUnresolvedMessage("Resolved [" + ua + "] unexpectedly to multiple attributes " + named);
            }
            return resolved;
        }

        private LogicalPlan resolveEval(Eval eval, List<Attribute> childOutput) {
            ArrayList<Attribute> allResolvedInputs = new ArrayList<Attribute>(childOutput);
            ArrayList<Alias> newFields = new ArrayList<Alias>();
            boolean changed = false;
            for (Alias field : eval.fields()) {
                Alias result = (Alias)field.transformUp(UnresolvedAttribute.class, ua -> this.resolveAttribute((UnresolvedAttribute)ua, (List<Attribute>)allResolvedInputs));
                changed |= result != field;
                newFields.add(result);
                if (!result.resolved()) continue;
                Attribute existing = allResolvedInputs.stream().filter(attr -> attr.name().equals(result.name())).findFirst().orElse(null);
                if (existing != null) {
                    allResolvedInputs.remove(existing);
                }
                allResolvedInputs.add(result.toAttribute());
            }
            return changed ? new Eval(eval.source(), eval.child(), newFields) : eval;
        }

        private LogicalPlan resolveKeep(Project p, List<Attribute> childOutput) {
            ArrayList<Object> resolvedProjections = new ArrayList<Object>();
            List projections = p.projections();
            if (projections.isEmpty() || projections.size() == 1 && projections.get(0) instanceof UnresolvedStar) {
                resolvedProjections.addAll(childOutput);
            } else {
                int starPosition = -1;
                for (NamedExpression ne : projections) {
                    if (ne instanceof UnresolvedStar) {
                        starPosition = resolvedProjections.size();
                        continue;
                    }
                    if (ne instanceof UnresolvedAttribute) {
                        UnresolvedAttribute ua = (UnresolvedAttribute)ne;
                        resolvedProjections.addAll(Analyzer.resolveAgainstList(ua, childOutput));
                        continue;
                    }
                    resolvedProjections.add(ne);
                }
                if (starPosition >= 0) {
                    ArrayList<Attribute> remainingProjections = new ArrayList<Attribute>(childOutput);
                    remainingProjections.removeAll(resolvedProjections);
                    resolvedProjections.addAll(starPosition, remainingProjections);
                }
            }
            return new EsqlProject(p.source(), p.child(), resolvedProjections);
        }

        private LogicalPlan resolveDrop(Drop drop, List<Attribute> childOutput) {
            ArrayList<Attribute> resolvedProjections = new ArrayList<Attribute>(childOutput);
            for (NamedExpression ne : drop.removals()) {
                List<NamedExpression> list;
                if (ne instanceof UnresolvedAttribute) {
                    UnresolvedAttribute ua = (UnresolvedAttribute)ne;
                    list = Analyzer.resolveAgainstList(ua, childOutput);
                } else {
                    list = Collections.singletonList(ne);
                }
                List<NamedExpression> resolved = list;
                resolvedProjections.removeIf(resolved::contains);
                resolved.forEach(r -> {
                    if (!r.resolved() && !(r instanceof UnsupportedAttribute)) {
                        resolvedProjections.add((Attribute)r);
                    }
                });
            }
            return new EsqlProject(drop.source(), drop.child(), resolvedProjections);
        }

        private LogicalPlan resolveRename(Rename rename, List<Attribute> childrenOutput) {
            ArrayList<Attribute> projections = new ArrayList<Attribute>(childrenOutput);
            int renamingsCount = rename.renamings().size();
            ArrayList unresolved = new ArrayList(renamingsCount);
            HashMap reverseAliasing = new HashMap(renamingsCount);
            rename.renamings().forEach(alias -> {
                Expression patt22388$temp = alias.child();
                if (patt22388$temp instanceof UnresolvedAttribute) {
                    UnresolvedAttribute ua = (UnresolvedAttribute)patt22388$temp;
                    if (!alias.name().equals(ua.name())) {
                        projections.removeIf(x -> x.name().equals(alias.name()));
                        Attribute resolved = this.maybeResolveAttribute(ua, childrenOutput);
                        if (resolved instanceof UnsupportedAttribute || resolved.resolved()) {
                            Alias realiased = alias.replaceChildren(List.of(resolved));
                            projections.replaceAll(arg_0 -> ResolveRefs.lambda$resolveRename$5(resolved, (NamedExpression)realiased, arg_0));
                            childrenOutput.removeIf(x -> x.equals((Object)resolved));
                            reverseAliasing.put(resolved.name(), alias.name());
                        } else {
                            boolean updated = false;
                            if (reverseAliasing.containsValue(resolved.name())) {
                                ListIterator<Alias> li = projections.listIterator();
                                while (li.hasNext()) {
                                    Alias a;
                                    Object patt23695$temp = li.next();
                                    if (!(patt23695$temp instanceof Alias) || !(a = (Alias)patt23695$temp).name().equals(resolved.name())) continue;
                                    reverseAliasing.put(resolved.name(), alias.name());
                                    li.set(alias.replaceChildren(a.children()));
                                    updated = true;
                                    break;
                                }
                            }
                            if (!updated) {
                                Attribute u = resolved;
                                String previousAliasName = (String)reverseAliasing.get(resolved.name());
                                if (previousAliasName != null) {
                                    String message = LoggerMessageFormat.format(null, (String)"Column [{}] renamed to [{}] and is no longer available [{}]", (Object[])new Object[]{resolved.name(), previousAliasName, alias.sourceText()});
                                    u = ua.withUnresolvedMessage(message);
                                }
                                unresolved.add(u);
                            }
                        }
                    }
                }
            });
            projections.addAll(unresolved);
            return new EsqlProject(rename.source(), rename.child(), projections);
        }

        private LogicalPlan resolveEnrich(Enrich enrich, List<Attribute> childrenOutput) {
            Attribute attribute = enrich.matchField().toAttribute();
            if (attribute instanceof UnresolvedAttribute) {
                UnresolvedAttribute ua = (UnresolvedAttribute)attribute;
                Attribute resolved = this.maybeResolveAttribute(ua, childrenOutput);
                if (resolved.equals((Object)ua)) {
                    return enrich;
                }
                if (resolved.resolved() && resolved.dataType() != DataTypes.KEYWORD) {
                    resolved = ua.withUnresolvedMessage("Unsupported type [" + resolved.dataType() + "] for enrich matching field [" + ua.name() + "]; only KEYWORD allowed");
                }
                return new Enrich(enrich.source(), enrich.child(), enrich.policyName(), (NamedExpression)resolved, enrich.policy(), enrich.enrichFields());
            }
            return enrich;
        }

        private static /* synthetic */ NamedExpression lambda$resolveRename$5(Attribute resolved, NamedExpression realiased, NamedExpression x) {
            return x.equals((Object)resolved) ? realiased : x;
        }
    }

    private static class ResolveFunctions
    extends AnalyzerRules.ParameterizedAnalyzerRule<LogicalPlan, AnalyzerContext> {
        private ResolveFunctions() {
        }

        protected LogicalPlan rule(LogicalPlan plan, AnalyzerContext context) {
            return (LogicalPlan)plan.transformExpressionsUp(UnresolvedFunction.class, uf -> AnalyzerRules.resolveFunction((UnresolvedFunction)uf, (Configuration)context.configuration(), (FunctionRegistry)context.functionRegistry()));
        }
    }

    private static class RemoveDuplicateProjections
    extends AnalyzerRules.BaseAnalyzerRule {
        private RemoveDuplicateProjections() {
        }

        protected boolean skipResolved() {
            return false;
        }

        protected LogicalPlan doRule(LogicalPlan plan) {
            if (plan.resolved() && plan instanceof Aggregate) {
                Aggregate agg = (Aggregate)plan;
                plan = RemoveDuplicateProjections.removeAggDuplicates(agg);
            }
            return plan;
        }

        private static LogicalPlan removeAggDuplicates(Aggregate agg) {
            List groupings = agg.groupings();
            LinkedHashSet newGroupings = new LinkedHashSet(groupings);
            groupings = newGroupings.size() == groupings.size() ? groupings : new ArrayList(newGroupings);
            ArrayList aggregates = agg.aggregates();
            ArrayList newAggregates = new ArrayList(aggregates);
            Set nameSet = Sets.newHashSetWithExpectedSize((int)newAggregates.size());
            for (int i = newAggregates.size() - 1; i >= 0; --i) {
                NamedExpression aggregate = (NamedExpression)newAggregates.get(i);
                if (nameSet.add(aggregate.name())) continue;
                newAggregates.remove(i);
            }
            aggregates = newAggregates.size() == aggregates.size() ? aggregates : newAggregates;
            agg = groupings == agg.groupings() && newAggregates == agg.aggregates() ? agg : new Aggregate(agg.source(), agg.child(), groupings, aggregates);
            return agg;
        }
    }

    private static class AddImplicitLimit
    extends ParameterizedRule<LogicalPlan, LogicalPlan, AnalyzerContext> {
        private AddImplicitLimit() {
        }

        public LogicalPlan apply(LogicalPlan logicalPlan, AnalyzerContext context) {
            int limit;
            List limits = logicalPlan.collectFirstChildren(Limit.class::isInstance);
            if (limits.isEmpty()) {
                HeaderWarning.addWarning((String)"No limit defined, adding default limit of [{}]", (Object[])new Object[]{context.configuration().resultTruncationDefaultSize()});
                limit = context.configuration().resultTruncationDefaultSize();
            } else {
                limit = context.configuration().resultTruncationMaxSize();
            }
            return new Limit(Source.EMPTY, (Expression)new Literal(Source.EMPTY, (Object)limit, DataTypes.INTEGER), logicalPlan);
        }
    }

    private static class PromoteStringsInDateComparisons
    extends Rule<LogicalPlan, LogicalPlan> {
        private PromoteStringsInDateComparisons() {
        }

        public LogicalPlan apply(LogicalPlan plan) {
            return (LogicalPlan)plan.transformExpressionsUp(BinaryComparison.class, PromoteStringsInDateComparisons::promote);
        }

        private static Expression promote(BinaryComparison cmp) {
            if (!cmp.resolved()) {
                return cmp;
            }
            Expression left = cmp.left();
            Expression right = cmp.right();
            boolean modified = false;
            if (left.dataType() == DataTypes.DATETIME) {
                if (right.dataType() == DataTypes.KEYWORD && right.foldable()) {
                    right = PromoteStringsInDateComparisons.stringToDate(right);
                    modified = true;
                }
            } else if (right.dataType() == DataTypes.DATETIME && left.dataType() == DataTypes.KEYWORD && left.foldable()) {
                left = PromoteStringsInDateComparisons.stringToDate(left);
                modified = true;
            }
            return modified ? cmp.replaceChildren(List.of(left, right)) : cmp;
        }

        private static Expression stringToDate(Expression stringExpression) {
            Literal result;
            String str = stringExpression.fold().toString();
            Long millis = null;
            try {
                millis = str == null ? null : Long.valueOf(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.parseMillis(str));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Source source = stringExpression.source();
            if (millis == null) {
                String errorMessage = LoggerMessageFormat.format(null, (String)"Invalid date [{}]", (Object[])new Object[]{str});
                result = new UnresolvedAttribute(source, source.text(), null, errorMessage);
            } else {
                result = new Literal(source, (Object)millis, DataTypes.DATETIME);
            }
            return result;
        }
    }
}

