/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.Build;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.esql.parser.ContentLocation;
import org.elasticsearch.xpack.esql.parser.TypedParamValue;
import org.elasticsearch.xpack.esql.plugin.QueryPragmas;

public class EsqlQueryRequest
extends ActionRequest
implements CompositeIndicesRequest {
    private static final ConstructingObjectParser<TypedParamValue, Void> PARAM_PARSER = new ConstructingObjectParser("params", true, objects -> new TypedParamValue((String)objects[1], objects[0]));
    private static final ParseField VALUE = new ParseField("value", new String[0]);
    private static final ParseField TYPE = new ParseField("type", new String[0]);
    private static final ParseField QUERY_FIELD;
    private static final ParseField COLUMNAR_FIELD;
    private static final ParseField FILTER_FIELD;
    private static final ParseField PRAGMA_FIELD;
    private static final ParseField PARAMS_FIELD;
    private static final ParseField LOCALE_FIELD;
    private static final ParseField PROFILE_FIELD;
    private static final ObjectParser<EsqlQueryRequest, Void> PARSER;
    private String query;
    private boolean columnar;
    private boolean profile;
    private Locale locale;
    private QueryBuilder filter;
    private QueryPragmas pragmas = new QueryPragmas(Settings.EMPTY);
    private List<TypedParamValue> params = List.of();

    public EsqlQueryRequest(StreamInput in) throws IOException {
        super(in);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!Strings.hasText((String)this.query)) {
            validationException = ValidateActions.addValidationError((String)"[query] is required", validationException);
        }
        if (!Build.current().isSnapshot() && !this.pragmas.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"[pragma] only allowed in snapshot builds", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public EsqlQueryRequest() {
    }

    public void query(String query) {
        this.query = query;
    }

    public String query() {
        return this.query;
    }

    public void columnar(boolean columnar) {
        this.columnar = columnar;
    }

    public boolean columnar() {
        return this.columnar;
    }

    public void profile(boolean profile) {
        this.profile = profile;
    }

    public boolean profile() {
        return this.profile;
    }

    public void locale(Locale locale) {
        this.locale = locale;
    }

    public Locale locale() {
        return this.locale;
    }

    public void filter(QueryBuilder filter) {
        this.filter = filter;
    }

    public QueryBuilder filter() {
        return this.filter;
    }

    public void pragmas(QueryPragmas pragmas) {
        this.pragmas = pragmas;
    }

    public QueryPragmas pragmas() {
        return this.pragmas;
    }

    public List<TypedParamValue> params() {
        return this.params;
    }

    public void params(List<TypedParamValue> params) {
        this.params = params;
    }

    public static EsqlQueryRequest fromXContent(XContentParser parser) {
        return (EsqlQueryRequest)((Object)PARSER.apply(parser, null));
    }

    private static ObjectParser<EsqlQueryRequest, Void> objectParser(Supplier<EsqlQueryRequest> supplier) {
        ObjectParser parser = new ObjectParser("esql/query", false, supplier);
        parser.declareString(EsqlQueryRequest::query, QUERY_FIELD);
        parser.declareBoolean(EsqlQueryRequest::columnar, COLUMNAR_FIELD);
        parser.declareObject(EsqlQueryRequest::filter, (p, c) -> AbstractQueryBuilder.parseTopLevelQuery((XContentParser)p), FILTER_FIELD);
        parser.declareObject(EsqlQueryRequest::pragmas, (p, c) -> new QueryPragmas(Settings.builder().loadFromMap(p.map()).build()), PRAGMA_FIELD);
        parser.declareField(EsqlQueryRequest::params, EsqlQueryRequest::parseParams, PARAMS_FIELD, ObjectParser.ValueType.VALUE_ARRAY);
        parser.declareString((request, localeTag) -> request.locale(Locale.forLanguageTag(localeTag)), LOCALE_FIELD);
        parser.declareBoolean(EsqlQueryRequest::profile, PROFILE_FIELD);
        return parser;
    }

    private static List<TypedParamValue> parseParams(XContentParser p) throws IOException {
        ArrayList<TypedParamValue> result = new ArrayList<TypedParamValue>();
        XContentParser.Token token = p.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            Object value = null;
            String type = null;
            TypedParamValue previousParam = null;
            while ((token = p.nextToken()) != XContentParser.Token.END_ARRAY) {
                TypedParamValue currentParam;
                XContentLocation loc = p.getTokenLocation();
                if (token == XContentParser.Token.START_OBJECT) {
                    currentParam = (TypedParamValue)PARAM_PARSER.apply(p, null);
                    if (previousParam != null && !previousParam.hasExplicitType() || result.isEmpty()) {
                        currentParam.tokenLocation(EsqlQueryRequest.toProto(loc));
                    }
                } else {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        value = p.text();
                        type = "keyword";
                    } else if (token == XContentParser.Token.VALUE_NUMBER) {
                        XContentParser.NumberType numberType = p.numberType();
                        if (numberType == XContentParser.NumberType.INT) {
                            value = p.intValue();
                            type = "integer";
                        } else if (numberType == XContentParser.NumberType.LONG) {
                            value = p.longValue();
                            type = "long";
                        } else if (numberType == XContentParser.NumberType.DOUBLE) {
                            value = p.doubleValue();
                            type = "double";
                        }
                    } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
                        value = p.booleanValue();
                        type = "boolean";
                    } else if (token == XContentParser.Token.VALUE_NULL) {
                        value = null;
                        type = "null";
                    } else {
                        throw new XContentParseException(loc, "Failed to parse object: unexpected token [" + token + "] found");
                    }
                    currentParam = new TypedParamValue(type, value, false);
                    if (previousParam != null && previousParam.hasExplicitType() || result.isEmpty()) {
                        currentParam.tokenLocation(EsqlQueryRequest.toProto(loc));
                    }
                }
                result.add(currentParam);
                previousParam = currentParam;
            }
        }
        return result;
    }

    static ContentLocation toProto(XContentLocation toProto) {
        if (toProto == null) {
            return null;
        }
        return new ContentLocation(toProto.lineNumber(), toProto.columnNumber());
    }

    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, this.query, parentTaskId, headers);
    }

    static XContentLocation fromProto(ContentLocation fromProto) {
        if (fromProto == null) {
            return null;
        }
        return new XContentLocation(fromProto.lineNumber, fromProto.columnNumber);
    }

    static {
        PARAM_PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> XContentParserUtils.parseFieldsValue((XContentParser)p), VALUE, ObjectParser.ValueType.VALUE);
        PARAM_PARSER.declareString(ConstructingObjectParser.constructorArg(), TYPE);
        QUERY_FIELD = new ParseField("query", new String[0]);
        COLUMNAR_FIELD = new ParseField("columnar", new String[0]);
        FILTER_FIELD = new ParseField("filter", new String[0]);
        PRAGMA_FIELD = new ParseField("pragma", new String[0]);
        PARAMS_FIELD = new ParseField("params", new String[0]);
        LOCALE_FIELD = new ParseField("locale", new String[0]);
        PROFILE_FIELD = new ParseField("profile", new String[0]);
        PARSER = EsqlQueryRequest.objectParser(EsqlQueryRequest::new);
    }
}

