/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.action;

import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.rollup.action.StartRollupJobAction;
import org.elasticsearch.xpack.rollup.action.TransportTaskHelper;
import org.elasticsearch.xpack.rollup.job.RollupJobTask;

public class TransportStartRollupAction
extends TransportTasksAction<RollupJobTask, StartRollupJobAction.Request, StartRollupJobAction.Response, StartRollupJobAction.Response> {
    @Inject
    public TransportStartRollupAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService) {
        super("cluster:admin/xpack/rollup/start", clusterService, transportService, actionFilters, StartRollupJobAction.Request::new, StartRollupJobAction.Response::new, StartRollupJobAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    protected List<RollupJobTask> processTasks(StartRollupJobAction.Request request) {
        return TransportTaskHelper.doProcessTasks(request.getId(), this.taskManager);
    }

    protected void taskOperation(CancellableTask actionTask, StartRollupJobAction.Request request, RollupJobTask jobTask, ActionListener<StartRollupJobAction.Response> listener) {
        if (jobTask.getConfig().getId().equals(request.getId())) {
            jobTask.start(listener);
        } else {
            listener.onFailure((Exception)new RuntimeException("ID of rollup task [" + jobTask.getConfig().getId() + "] does not match request's ID [" + request.getId() + "]"));
        }
    }

    protected StartRollupJobAction.Response newResponse(StartRollupJobAction.Request request, List<StartRollupJobAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (!taskOperationFailures.isEmpty()) {
            throw ExceptionsHelper.convertToElastic((Exception)taskOperationFailures.get(0).getCause());
        }
        if (!failedNodeExceptions.isEmpty()) {
            throw ExceptionsHelper.convertToElastic((Exception)((Exception)failedNodeExceptions.get(0)));
        }
        if (tasks.size() == 0) {
            throw new ResourceNotFoundException("Task for Rollup Job [" + request.getId() + "] not found", new Object[0]);
        }
        assert (tasks.size() == 1);
        boolean allStarted = tasks.stream().allMatch(StartRollupJobAction.Response::isStarted);
        return new StartRollupJobAction.Response(allStarted);
    }
}

