/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.autoscaling;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.inference.assignment.AllocationStatus;
import org.elasticsearch.xpack.core.ml.inference.assignment.AssignmentState;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignment;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeState;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeTaskParams;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.inference.assignment.TrainedModelAssignmentMetadata;
import org.elasticsearch.xpack.ml.job.JobNodeSelector;

class MlAutoscalingContext {
    final Collection<PersistentTasksCustomMetadata.PersistentTask<?>> anomalyDetectionTasks;
    final Collection<PersistentTasksCustomMetadata.PersistentTask<?>> snapshotUpgradeTasks;
    final Collection<PersistentTasksCustomMetadata.PersistentTask<?>> dataframeAnalyticsTasks;
    final Map<String, TrainedModelAssignment> modelAssignments;
    final List<String> waitingAnomalyJobs;
    final List<String> waitingSnapshotUpgrades;
    final List<String> waitingAnalyticsJobs;
    final List<String> waitingAllocatedModels;
    final List<DiscoveryNode> mlNodes;
    final PersistentTasksCustomMetadata persistentTasks;

    MlAutoscalingContext() {
        this(List.of(), List.of(), List.of(), Map.of(), List.of(), null);
    }

    MlAutoscalingContext(Collection<PersistentTasksCustomMetadata.PersistentTask<?>> anomalyDetectionTasks, Collection<PersistentTasksCustomMetadata.PersistentTask<?>> snapshotUpgradeTasks, Collection<PersistentTasksCustomMetadata.PersistentTask<?>> dataframeAnalyticsTasks, Map<String, TrainedModelAssignment> modelAssignments, List<DiscoveryNode> mlNodes, PersistentTasksCustomMetadata persistentTasks) {
        this.anomalyDetectionTasks = anomalyDetectionTasks;
        this.snapshotUpgradeTasks = snapshotUpgradeTasks;
        this.dataframeAnalyticsTasks = dataframeAnalyticsTasks;
        this.modelAssignments = modelAssignments;
        this.mlNodes = mlNodes;
        this.persistentTasks = persistentTasks;
        this.waitingAnomalyJobs = MlAutoscalingContext.waitingAnomalyJobs(anomalyDetectionTasks);
        this.waitingSnapshotUpgrades = MlAutoscalingContext.getWaitingSnapshotUpgrades(snapshotUpgradeTasks);
        this.waitingAnalyticsJobs = MlAutoscalingContext.getWaitingAnalyticsJobs(dataframeAnalyticsTasks);
        this.waitingAllocatedModels = MlAutoscalingContext.getWaitingAllocatedModels(modelAssignments);
    }

    MlAutoscalingContext(ClusterState clusterState) {
        this.persistentTasks = (PersistentTasksCustomMetadata)clusterState.getMetadata().custom("persistent_tasks");
        this.anomalyDetectionTasks = MlAutoscalingContext.anomalyDetectionTasks(this.persistentTasks);
        this.snapshotUpgradeTasks = MlAutoscalingContext.snapshotUpgradeTasks(this.persistentTasks);
        this.dataframeAnalyticsTasks = MlAutoscalingContext.dataframeAnalyticsTasks(this.persistentTasks);
        this.modelAssignments = TrainedModelAssignmentMetadata.fromState(clusterState).allAssignments();
        this.waitingAnomalyJobs = MlAutoscalingContext.waitingAnomalyJobs(this.anomalyDetectionTasks);
        this.waitingSnapshotUpgrades = MlAutoscalingContext.getWaitingSnapshotUpgrades(this.snapshotUpgradeTasks);
        this.waitingAnalyticsJobs = MlAutoscalingContext.getWaitingAnalyticsJobs(this.dataframeAnalyticsTasks);
        this.waitingAllocatedModels = MlAutoscalingContext.getWaitingAllocatedModels(this.modelAssignments);
        this.mlNodes = MlAutoscalingContext.getMlNodes(clusterState);
    }

    private static List<String> getWaitingAllocatedModels(Map<String, TrainedModelAssignment> modelAssignments) {
        return modelAssignments.entrySet().stream().filter(e -> ((TrainedModelAssignment)e.getValue()).getAssignmentState().equals((Object)AssignmentState.STARTING) && ((TrainedModelAssignment)e.getValue()).getNodeRoutingTable().isEmpty()).map(Map.Entry::getKey).toList();
    }

    private static List<String> getWaitingAnalyticsJobs(Collection<PersistentTasksCustomMetadata.PersistentTask<?>> dataframeAnalyticsTasks) {
        return dataframeAnalyticsTasks.stream().filter(t -> JobNodeSelector.AWAITING_LAZY_ASSIGNMENT.equals((Object)t.getAssignment())).map(t -> ((StartDataFrameAnalyticsAction.TaskParams)t.getParams()).getId()).toList();
    }

    private static List<String> getWaitingSnapshotUpgrades(Collection<PersistentTasksCustomMetadata.PersistentTask<?>> snapshotUpgradeTasks) {
        return snapshotUpgradeTasks.stream().filter(t -> JobNodeSelector.AWAITING_LAZY_ASSIGNMENT.equals((Object)t.getAssignment())).map(t -> ((SnapshotUpgradeTaskParams)t.getParams()).getJobId()).toList();
    }

    private static List<String> waitingAnomalyJobs(Collection<PersistentTasksCustomMetadata.PersistentTask<?>> anomalyDetectionTasks) {
        return anomalyDetectionTasks.stream().filter(t -> JobNodeSelector.AWAITING_LAZY_ASSIGNMENT.equals((Object)t.getAssignment())).map(t -> ((OpenJobAction.JobParams)t.getParams()).getJobId()).toList();
    }

    private static Collection<PersistentTasksCustomMetadata.PersistentTask<?>> anomalyDetectionTasks(PersistentTasksCustomMetadata tasksCustomMetadata) {
        if (tasksCustomMetadata == null) {
            return List.of();
        }
        return tasksCustomMetadata.findTasks("xpack/ml/job", t -> MlAutoscalingContext.taskStateFilter(MlTasks.getJobStateModifiedForReassignments((PersistentTasksCustomMetadata.PersistentTask)t)));
    }

    private static Collection<PersistentTasksCustomMetadata.PersistentTask<?>> snapshotUpgradeTasks(PersistentTasksCustomMetadata tasksCustomMetadata) {
        if (tasksCustomMetadata == null) {
            return List.of();
        }
        return tasksCustomMetadata.findTasks("xpack/ml/job/snapshot/upgrade", t -> MlAutoscalingContext.taskStateFilter(MlTasks.getSnapshotUpgradeState((PersistentTasksCustomMetadata.PersistentTask)t)));
    }

    static Collection<PersistentTasksCustomMetadata.PersistentTask<?>> dataframeAnalyticsTasks(PersistentTasksCustomMetadata tasksCustomMetadata) {
        if (tasksCustomMetadata == null) {
            return List.of();
        }
        return tasksCustomMetadata.findTasks("xpack/ml/data_frame/analytics", t -> MlAutoscalingContext.taskStateFilter(MlTasks.getDataFrameAnalyticsState((PersistentTasksCustomMetadata.PersistentTask)t)));
    }

    private static boolean taskStateFilter(JobState jobState) {
        return jobState == null || jobState.isNoneOf(new JobState[]{JobState.CLOSED, JobState.FAILED});
    }

    private static boolean taskStateFilter(SnapshotUpgradeState snapshotUpgradeState) {
        return snapshotUpgradeState == null || snapshotUpgradeState.isNoneOf(new SnapshotUpgradeState[]{SnapshotUpgradeState.STOPPED, SnapshotUpgradeState.FAILED});
    }

    private static boolean taskStateFilter(DataFrameAnalyticsState dataFrameAnalyticsState) {
        return dataFrameAnalyticsState == null || dataFrameAnalyticsState.isNoneOf(new DataFrameAnalyticsState[]{DataFrameAnalyticsState.STOPPED, DataFrameAnalyticsState.FAILED});
    }

    public boolean hasWaitingTasks() {
        return !this.waitingAnomalyJobs.isEmpty() || !this.waitingSnapshotUpgrades.isEmpty() || !this.waitingAnalyticsJobs.isEmpty() || !this.waitingAllocatedModels.isEmpty();
    }

    public boolean isEmpty() {
        return this.anomalyDetectionTasks.isEmpty() && this.snapshotUpgradeTasks.isEmpty() && this.dataframeAnalyticsTasks.isEmpty() && this.modelAssignments.isEmpty();
    }

    public List<String> findPartiallyAllocatedModels() {
        return this.modelAssignments.entrySet().stream().filter(e -> !((TrainedModelAssignment)e.getValue()).calculateAllocationStatus().map(AllocationStatus::calculateState).orElse(AllocationStatus.State.FULLY_ALLOCATED).equals((Object)AllocationStatus.State.FULLY_ALLOCATED)).map(Map.Entry::getKey).toList();
    }

    static List<DiscoveryNode> getMlNodes(ClusterState clusterState) {
        return clusterState.nodes().mastersFirstStream().filter(MachineLearning::isMlNode).toList();
    }
}

