/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.compute.data.AbstractBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;

final class LongBlockBuilder
extends AbstractBlockBuilder
implements LongBlock.Builder {
    private long[] values;

    LongBlockBuilder(int estimatedSize, BlockFactory blockFactory) {
        super(blockFactory);
        int initialSize = Math.max(estimatedSize, 2);
        this.adjustBreaker(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + initialSize * this.elementSize());
        this.values = new long[initialSize];
    }

    @Override
    public LongBlockBuilder appendLong(long value) {
        this.ensureCapacity();
        this.values[this.valueCount] = value;
        this.hasNonNullValue = true;
        ++this.valueCount;
        this.updatePosition();
        return this;
    }

    @Override
    protected int elementSize() {
        return 8;
    }

    @Override
    protected int valuesLength() {
        return this.values.length;
    }

    @Override
    protected void growValuesArray(int newSize) {
        this.values = Arrays.copyOf(this.values, newSize);
    }

    @Override
    public LongBlockBuilder appendNull() {
        super.appendNull();
        return this;
    }

    @Override
    public LongBlockBuilder beginPositionEntry() {
        super.beginPositionEntry();
        return this;
    }

    @Override
    public LongBlockBuilder endPositionEntry() {
        super.endPositionEntry();
        return this;
    }

    @Override
    public LongBlockBuilder appendAllValuesToCurrentPosition(Block block) {
        if (block.areAllValuesNull()) {
            return this.appendNull();
        }
        return this.appendAllValuesToCurrentPosition((LongBlock)block);
    }

    @Override
    public LongBlockBuilder appendAllValuesToCurrentPosition(LongBlock block) {
        LongVector vector;
        int positionCount = block.getPositionCount();
        if (positionCount == 0) {
            return this.appendNull();
        }
        int totalValueCount = block.getTotalValueCount();
        if (totalValueCount == 0) {
            return this.appendNull();
        }
        if (totalValueCount > 1) {
            this.beginPositionEntry();
        }
        if ((vector = block.asVector()) != null) {
            for (int p = 0; p < positionCount; ++p) {
                this.appendLong(vector.getLong(p));
            }
        } else {
            for (int p = 0; p < positionCount; ++p) {
                int count = block.getValueCount(p);
                int i = block.getFirstValueIndex(p);
                for (int v = 0; v < count; ++v) {
                    this.appendLong(block.getLong(i++));
                }
            }
        }
        if (totalValueCount > 1) {
            this.endPositionEntry();
        }
        return this;
    }

    @Override
    public LongBlockBuilder copyFrom(Block block, int beginInclusive, int endExclusive) {
        if (block.areAllValuesNull()) {
            for (int p = beginInclusive; p < endExclusive; ++p) {
                this.appendNull();
            }
            return this;
        }
        return this.copyFrom((LongBlock)block, beginInclusive, endExclusive);
    }

    @Override
    public LongBlockBuilder copyFrom(LongBlock block, int beginInclusive, int endExclusive) {
        if (endExclusive > block.getPositionCount()) {
            throw new IllegalArgumentException("can't copy past the end [" + endExclusive + " > " + block.getPositionCount() + "]");
        }
        LongVector vector = block.asVector();
        if (vector != null) {
            this.copyFromVector(vector, beginInclusive, endExclusive);
        } else {
            this.copyFromBlock(block, beginInclusive, endExclusive);
        }
        return this;
    }

    private void copyFromBlock(LongBlock block, int beginInclusive, int endExclusive) {
        for (int p = beginInclusive; p < endExclusive; ++p) {
            if (block.isNull(p)) {
                this.appendNull();
                continue;
            }
            int count = block.getValueCount(p);
            if (count > 1) {
                this.beginPositionEntry();
            }
            int i = block.getFirstValueIndex(p);
            for (int v = 0; v < count; ++v) {
                this.appendLong(block.getLong(i++));
            }
            if (count <= 1) continue;
            this.endPositionEntry();
        }
    }

    private void copyFromVector(LongVector vector, int beginInclusive, int endExclusive) {
        for (int p = beginInclusive; p < endExclusive; ++p) {
            this.appendLong(vector.getLong(p));
        }
    }

    @Override
    public LongBlockBuilder mvOrdering(Block.MvOrdering mvOrdering) {
        this.mvOrdering = mvOrdering;
        return this;
    }

    @Override
    public LongBlock build() {
        try {
            LongBlock theBlock;
            this.finish();
            if (this.hasNonNullValue && this.positionCount == 1 && this.valueCount == 1) {
                theBlock = this.blockFactory.newConstantLongBlockWith(this.values[0], 1, this.estimatedBytes);
            } else {
                if (this.values.length - this.valueCount > 1024 || this.valueCount < this.values.length / 2) {
                    this.values = Arrays.copyOf(this.values, this.valueCount);
                }
                theBlock = this.isDense() && this.singleValued() ? this.blockFactory.newLongArrayVector(this.values, this.positionCount, this.estimatedBytes).asBlock() : this.blockFactory.newLongArrayBlock(this.values, this.positionCount, this.firstValueIndexes, this.nullsMask, this.mvOrdering, this.estimatedBytes);
            }
            this.built();
            return theBlock;
        }
        catch (CircuitBreakingException e) {
            this.close();
            throw e;
        }
    }
}

