/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.elasticsearch.compute.data.AbstractVectorBlock;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public final class IntVectorBlock
extends AbstractVectorBlock
implements IntBlock {
    private final IntVector vector;

    IntVectorBlock(IntVector vector) {
        super(vector.getPositionCount(), vector.blockFactory());
        this.vector = vector;
    }

    @Override
    public IntVector asVector() {
        return this.vector;
    }

    @Override
    public int getInt(int valueIndex) {
        return this.vector.getInt(valueIndex);
    }

    @Override
    public int getTotalValueCount() {
        return this.vector.getPositionCount();
    }

    @Override
    public ElementType elementType() {
        return this.vector.elementType();
    }

    @Override
    public IntBlock filter(int ... positions) {
        return this.vector.filter(positions).asBlock();
    }

    public long ramBytesUsed() {
        return this.vector.ramBytesUsed();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IntBlock) {
            IntBlock that = (IntBlock)obj;
            return IntBlock.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return IntBlock.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[vector=" + this.vector + "]";
    }

    @Override
    public boolean isReleased() {
        return super.isReleased() || this.vector.isReleased();
    }

    @Override
    public void closeInternal() {
        assert (!this.vector.isReleased()) : "can't release block [" + this + "] containing already released vector";
        Releasables.closeExpectNoException((Releasable)this.vector);
    }

    @Override
    public void allowPassingToDifferentDriver() {
        this.vector.allowPassingToDifferentDriver();
    }

    @Override
    public BlockFactory blockFactory() {
        return this.vector.blockFactory();
    }
}

