/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.Vector;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface IntVector
extends Vector {
    public int getInt(int var1);

    @Override
    public IntBlock asBlock();

    @Override
    public IntVector filter(int ... var1);

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(IntVector vector1, IntVector vector2) {
        int positions = vector1.getPositionCount();
        if (positions != vector2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (vector1.getInt(pos) == vector2.getInt(pos)) continue;
            return false;
        }
        return true;
    }

    public static int hash(IntVector vector) {
        int len = vector.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < len; ++pos) {
            result = 31 * result + vector.getInt(pos);
        }
        return result;
    }

    public static IntVector readFrom(BlockFactory blockFactory, StreamInput in) throws IOException {
        int positions = in.readVInt();
        boolean constant = in.readBoolean();
        if (constant && positions > 0) {
            return blockFactory.newConstantIntVector(in.readInt(), positions);
        }
        try (FixedBuilder builder = blockFactory.newIntVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                builder.appendInt(in.readInt());
            }
            IntVector intVector = builder.build();
            return intVector;
        }
    }

    default public void writeTo(StreamOutput out) throws IOException {
        int positions = this.getPositionCount();
        out.writeVInt(positions);
        out.writeBoolean(this.isConstant());
        if (this.isConstant() && positions > 0) {
            out.writeInt(this.getInt(0));
        } else {
            for (int i = 0; i < positions; ++i) {
                out.writeInt(this.getInt(i));
            }
        }
    }

    @Deprecated
    public static Builder newVectorBuilder(int estimatedSize) {
        return IntVector.newVectorBuilder(estimatedSize, BlockFactory.getNonBreakingInstance());
    }

    @Deprecated
    public static Builder newVectorBuilder(int estimatedSize, BlockFactory blockFactory) {
        return blockFactory.newIntVectorBuilder(estimatedSize);
    }

    @Deprecated
    public static FixedBuilder newVectorFixedBuilder(int size, BlockFactory blockFactory) {
        return blockFactory.newIntVectorFixedBuilder(size);
    }

    public static IntVector range(int startInclusive, int endExclusive, BlockFactory blockFactory) {
        int[] values = new int[endExclusive - startInclusive];
        for (int i = 0; i < values.length; ++i) {
            values[i] = startInclusive + i;
        }
        return blockFactory.newIntArrayVector(values, values.length);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface FixedBuilder
    extends Vector.Builder {
        public FixedBuilder appendInt(int var1);

        @Override
        public IntVector build();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Builder
    extends Vector.Builder {
        public Builder appendInt(int var1);

        @Override
        public IntVector build();
    }
}

