/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.Vector;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface DoubleVector
extends Vector {
    public double getDouble(int var1);

    @Override
    public DoubleBlock asBlock();

    @Override
    public DoubleVector filter(int ... var1);

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(DoubleVector vector1, DoubleVector vector2) {
        int positions = vector1.getPositionCount();
        if (positions != vector2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (vector1.getDouble(pos) == vector2.getDouble(pos)) continue;
            return false;
        }
        return true;
    }

    public static int hash(DoubleVector vector) {
        int len = vector.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < len; ++pos) {
            long element = Double.doubleToLongBits(vector.getDouble(pos));
            result = 31 * result + (int)(element ^ element >>> 32);
        }
        return result;
    }

    public static DoubleVector readFrom(BlockFactory blockFactory, StreamInput in) throws IOException {
        int positions = in.readVInt();
        boolean constant = in.readBoolean();
        if (constant && positions > 0) {
            return blockFactory.newConstantDoubleVector(in.readDouble(), positions);
        }
        try (FixedBuilder builder = blockFactory.newDoubleVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                builder.appendDouble(in.readDouble());
            }
            DoubleVector doubleVector = builder.build();
            return doubleVector;
        }
    }

    default public void writeTo(StreamOutput out) throws IOException {
        int positions = this.getPositionCount();
        out.writeVInt(positions);
        out.writeBoolean(this.isConstant());
        if (this.isConstant() && positions > 0) {
            out.writeDouble(this.getDouble(0));
        } else {
            for (int i = 0; i < positions; ++i) {
                out.writeDouble(this.getDouble(i));
            }
        }
    }

    @Deprecated
    public static Builder newVectorBuilder(int estimatedSize) {
        return DoubleVector.newVectorBuilder(estimatedSize, BlockFactory.getNonBreakingInstance());
    }

    @Deprecated
    public static Builder newVectorBuilder(int estimatedSize, BlockFactory blockFactory) {
        return blockFactory.newDoubleVectorBuilder(estimatedSize);
    }

    @Deprecated
    public static FixedBuilder newVectorFixedBuilder(int size, BlockFactory blockFactory) {
        return blockFactory.newDoubleVectorFixedBuilder(size);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface FixedBuilder
    extends Vector.Builder {
        public FixedBuilder appendDouble(double var1);

        @Override
        public DoubleVector build();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Builder
    extends Vector.Builder {
        public Builder appendDouble(double var1);

        @Override
        public DoubleVector build();
    }
}

