/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.Arrays;
import java.util.BitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.AbstractArrayBlock;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockRamUsageEstimator;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;

public final class DoubleArrayBlock
extends AbstractArrayBlock
implements DoubleBlock {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DoubleArrayBlock.class);
    private final double[] values;

    public DoubleArrayBlock(double[] values, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering) {
        this(values, positionCount, firstValueIndexes, nulls, mvOrdering, BlockFactory.getNonBreakingInstance());
    }

    public DoubleArrayBlock(double[] values, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering, BlockFactory blockFactory) {
        super(positionCount, firstValueIndexes, nulls, mvOrdering, blockFactory);
        this.values = values;
    }

    @Override
    public DoubleVector asVector() {
        return null;
    }

    @Override
    public double getDouble(int valueIndex) {
        return this.values[valueIndex];
    }

    @Override
    public DoubleBlock filter(int ... positions) {
        try (DoubleBlock.Builder builder = this.blockFactory().newDoubleBlockBuilder(positions.length);){
            for (int pos : positions) {
                if (this.isNull(pos)) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = this.getValueCount(pos);
                int first = this.getFirstValueIndex(pos);
                if (valueCount == 1) {
                    builder.appendDouble(this.getDouble(this.getFirstValueIndex(pos)));
                    continue;
                }
                builder.beginPositionEntry();
                for (int c = 0; c < valueCount; ++c) {
                    builder.appendDouble(this.getDouble(first + c));
                }
                builder.endPositionEntry();
            }
            DoubleBlock doubleBlock = builder.mvOrdering(this.mvOrdering()).build();
            return doubleBlock;
        }
    }

    @Override
    public ElementType elementType() {
        return ElementType.DOUBLE;
    }

    @Override
    public DoubleBlock expand() {
        if (this.firstValueIndexes == null) {
            this.incRef();
            return this;
        }
        try (DoubleBlock.Builder builder = this.blockFactory().newDoubleBlockBuilder(this.firstValueIndexes[this.getPositionCount()]);){
            for (int pos = 0; pos < this.getPositionCount(); ++pos) {
                if (this.isNull(pos)) {
                    builder.appendNull();
                    continue;
                }
                int first = this.getFirstValueIndex(pos);
                int end = first + this.getValueCount(pos);
                for (int i = first; i < end; ++i) {
                    builder.appendDouble(this.getDouble(i));
                }
            }
            DoubleBlock doubleBlock = builder.mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING).build();
            return doubleBlock;
        }
    }

    public static long ramBytesEstimated(double[] values, int[] firstValueIndexes, BitSet nullsMask) {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((double[])values) + BlockRamUsageEstimator.sizeOf(firstValueIndexes) + BlockRamUsageEstimator.sizeOfBitSet(nullsMask);
    }

    public long ramBytesUsed() {
        return DoubleArrayBlock.ramBytesEstimated(this.values, this.firstValueIndexes, this.nullsMask);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DoubleBlock) {
            DoubleBlock that = (DoubleBlock)obj;
            return DoubleBlock.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return DoubleBlock.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", mvOrdering=" + this.mvOrdering() + ", values=" + Arrays.toString(this.values) + "]";
    }

    @Override
    public void closeInternal() {
        this.blockFactory().adjustBreaker(-this.ramBytesUsed(), true);
    }
}

