/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.BitSet;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.BytesRefArray;
import org.elasticsearch.compute.data.AbstractArrayBlock;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockRamUsageEstimator;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public final class BytesRefArrayBlock
extends AbstractArrayBlock
implements BytesRefBlock {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BytesRefArrayBlock.class);
    private final BytesRefArray values;

    public BytesRefArrayBlock(BytesRefArray values, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering) {
        this(values, positionCount, firstValueIndexes, nulls, mvOrdering, BlockFactory.getNonBreakingInstance());
    }

    public BytesRefArrayBlock(BytesRefArray values, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering, BlockFactory blockFactory) {
        super(positionCount, firstValueIndexes, nulls, mvOrdering, blockFactory);
        this.values = values;
    }

    @Override
    public BytesRefVector asVector() {
        return null;
    }

    @Override
    public BytesRef getBytesRef(int valueIndex, BytesRef dest) {
        return this.values.get((long)valueIndex, dest);
    }

    @Override
    public BytesRefBlock filter(int ... positions) {
        BytesRef scratch = new BytesRef();
        try (BytesRefBlock.Builder builder = this.blockFactory().newBytesRefBlockBuilder(positions.length);){
            for (int pos : positions) {
                if (this.isNull(pos)) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = this.getValueCount(pos);
                int first = this.getFirstValueIndex(pos);
                if (valueCount == 1) {
                    builder.appendBytesRef(this.getBytesRef(this.getFirstValueIndex(pos), scratch));
                    continue;
                }
                builder.beginPositionEntry();
                for (int c = 0; c < valueCount; ++c) {
                    builder.appendBytesRef(this.getBytesRef(first + c, scratch));
                }
                builder.endPositionEntry();
            }
            BytesRefBlock bytesRefBlock = builder.mvOrdering(this.mvOrdering()).build();
            return bytesRefBlock;
        }
    }

    @Override
    public ElementType elementType() {
        return ElementType.BYTES_REF;
    }

    @Override
    public BytesRefBlock expand() {
        if (this.firstValueIndexes == null) {
            this.incRef();
            return this;
        }
        BytesRef scratch = new BytesRef();
        try (BytesRefBlock.Builder builder = this.blockFactory().newBytesRefBlockBuilder(this.firstValueIndexes[this.getPositionCount()]);){
            for (int pos = 0; pos < this.getPositionCount(); ++pos) {
                if (this.isNull(pos)) {
                    builder.appendNull();
                    continue;
                }
                int first = this.getFirstValueIndex(pos);
                int end = first + this.getValueCount(pos);
                for (int i = first; i < end; ++i) {
                    builder.appendBytesRef(this.getBytesRef(i, scratch));
                }
            }
            BytesRefBlock bytesRefBlock = builder.mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING).build();
            return bytesRefBlock;
        }
    }

    public static long ramBytesEstimated(BytesRefArray values, int[] firstValueIndexes, BitSet nullsMask) {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((Accountable)values) + BlockRamUsageEstimator.sizeOf(firstValueIndexes) + BlockRamUsageEstimator.sizeOfBitSet(nullsMask);
    }

    public long ramBytesUsed() {
        return BytesRefArrayBlock.ramBytesEstimated(this.values, this.firstValueIndexes, this.nullsMask);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BytesRefBlock) {
            BytesRefBlock that = (BytesRefBlock)obj;
            return BytesRefBlock.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BytesRefBlock.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", mvOrdering=" + this.mvOrdering() + ", values=" + this.values.size() + "]";
    }

    @Override
    public void closeInternal() {
        this.blockFactory().adjustBreaker(-this.ramBytesUsed() + this.values.bigArraysRamBytesUsed(), true);
        Releasables.closeExpectNoException((Releasable)this.values);
    }
}

