/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.common.util.LongLongHash;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.aggregation.blockhash.LongLongBlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntArrayVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

final class BytesRefLongBlockHash
extends BlockHash {
    private final int channel1;
    private final int channel2;
    private final boolean reverseOutput;
    private final int emitBatchSize;
    private final BytesRefHash bytesHash;
    private final LongLongHash finalHash;
    private static final long[] EMPTY = new long[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    BytesRefLongBlockHash(DriverContext driverContext, int channel1, int channel2, boolean reverseOutput, int emitBatchSize) {
        super(driverContext);
        this.channel1 = channel1;
        this.channel2 = channel2;
        this.reverseOutput = reverseOutput;
        this.emitBatchSize = emitBatchSize;
        boolean success = false;
        BytesRefHash bytesHash = null;
        LongLongHash longHash = null;
        try {
            bytesHash = new BytesRefHash(1L, this.bigArrays);
            longHash = new LongLongHash(1L, this.bigArrays);
            this.bytesHash = bytesHash;
            this.finalHash = longHash;
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            Releasables.close(bytesHash);
            throw throwable;
        }
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.bytesHash, this.finalHash});
    }

    @Override
    public void add(Page page, GroupingAggregatorFunction.AddInput addInput) {
        BytesRefBlock block1 = (BytesRefBlock)page.getBlock(this.channel1);
        LongBlock block2 = (LongBlock)page.getBlock(this.channel2);
        BytesRefVector vector1 = block1.asVector();
        LongVector vector2 = block2.asVector();
        if (vector1 != null && vector2 != null) {
            addInput.add(0, this.add(vector1, vector2));
        } else {
            try (AddWork work = new AddWork(block1, block2, addInput);){
                work.add();
            }
        }
    }

    public IntVector add(BytesRefVector vector1, LongVector vector2) {
        BytesRef scratch = new BytesRef();
        int positions = vector1.getPositionCount();
        int[] ords = new int[positions];
        for (int i = 0; i < positions; ++i) {
            long hash1 = BytesRefLongBlockHash.hashOrdToGroup(this.bytesHash.add(vector1.getBytesRef(i, scratch)));
            ords[i] = Math.toIntExact(BytesRefLongBlockHash.hashOrdToGroup(this.finalHash.add(hash1, vector2.getLong(i))));
        }
        return new IntArrayVector(ords, positions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Block[] getKeys() {
        LongVector k2;
        BytesRefVector k1;
        block18: {
            int positions = (int)this.finalHash.size();
            k1 = null;
            k2 = null;
            try {
                try (BytesRefVector.Builder keys1 = this.blockFactory.newBytesRefVectorBuilder(positions);
                     LongVector.Builder keys2 = this.blockFactory.newLongVectorBuilder(positions);){
                    BytesRef scratch = new BytesRef();
                    for (long i = 0L; i < (long)positions; ++i) {
                        keys2.appendLong(this.finalHash.getKey2(i));
                        long h1 = this.finalHash.getKey1(i);
                        keys1.appendBytesRef(this.bytesHash.get(h1, scratch));
                    }
                    k1 = keys1.build();
                    k2 = keys2.build();
                }
                if (k2 != null) break block18;
            }
            catch (Throwable throwable) {
                if (k2 == null) {
                    Releasables.closeExpectNoException(k1);
                }
                throw throwable;
            }
            Releasables.closeExpectNoException((Releasable)k1);
        }
        if (this.reverseOutput) {
            return new Block[]{k2.asBlock(), k1.asBlock()};
        }
        return new Block[]{k1.asBlock(), k2.asBlock()};
    }

    @Override
    public BitArray seenGroupIds(BigArrays bigArrays) {
        return new SeenGroupIds.Range(0, Math.toIntExact(this.finalHash.size())).seenGroupIds(bigArrays);
    }

    @Override
    public IntVector nonEmpty() {
        return IntVector.range(0, Math.toIntExact(this.finalHash.size()), this.blockFactory);
    }

    public String toString() {
        return "BytesRefLongBlockHash{keys=[BytesRefKey[channel=" + this.channel1 + "], LongKey[channel=" + this.channel2 + "]], entries=" + this.finalHash.size() + ", size=" + this.bytesHash.ramBytesUsed() + "b}";
    }

    private class AddWork
    extends LongLongBlockHash.AbstractAddBlock {
        private final BytesRefBlock block1;
        private final LongBlock block2;

        AddWork(BytesRefBlock block1, LongBlock block2, GroupingAggregatorFunction.AddInput addInput) {
            super(BytesRefLongBlockHash.this.blockFactory, BytesRefLongBlockHash.this.emitBatchSize, addInput);
            this.block1 = block1;
            this.block2 = block2;
        }

        void add() {
            BytesRef scratch = new BytesRef();
            int positions = this.block1.getPositionCount();
            long[] seen1 = EMPTY;
            long[] seen2 = EMPTY;
            for (int p = 0; p < positions; ++p) {
                if (this.block1.isNull(p) || this.block2.isNull(p)) {
                    this.ords.appendNull();
                    this.addedValue(p);
                    continue;
                }
                int start1 = this.block1.getFirstValueIndex(p);
                int start2 = this.block2.getFirstValueIndex(p);
                int count1 = this.block1.getValueCount(p);
                int count2 = this.block2.getValueCount(p);
                if (count1 == 1 && count2 == 1) {
                    long bytesOrd = BlockHash.hashOrdToGroup(BytesRefLongBlockHash.this.bytesHash.add(this.block1.getBytesRef(start1, scratch)));
                    this.ords.appendInt(Math.toIntExact(BlockHash.hashOrdToGroup(BytesRefLongBlockHash.this.finalHash.add(bytesOrd, this.block2.getLong(start2)))));
                    this.addedValue(p);
                    continue;
                }
                int end = start1 + count1;
                if (seen1.length < count1) {
                    seen1 = new long[ArrayUtil.oversize((int)count1, (int)8)];
                }
                int seenSize1 = 0;
                for (int i = start1; i < end; ++i) {
                    long bytesOrd = BytesRefLongBlockHash.this.bytesHash.add(this.block1.getBytesRef(i, scratch));
                    if (bytesOrd < 0L) {
                        seenSize1 = LongLongBlockHash.add(seen1, seenSize1, -1L - bytesOrd);
                        continue;
                    }
                    seen1[seenSize1++] = bytesOrd;
                }
                if (seen2.length < count2) {
                    seen2 = new long[ArrayUtil.oversize((int)count2, (int)8)];
                }
                int seenSize2 = 0;
                end = start2 + count2;
                for (int i = start2; i < end; ++i) {
                    seenSize2 = LongLongBlockHash.add(seen2, seenSize2, this.block2.getLong(i));
                }
                if (seenSize1 == 1 && seenSize2 == 1) {
                    this.ords.appendInt(Math.toIntExact(BlockHash.hashOrdToGroup(BytesRefLongBlockHash.this.finalHash.add(seen1[0], seen2[0]))));
                    this.addedValue(p);
                    continue;
                }
                this.ords.beginPositionEntry();
                for (int s1 = 0; s1 < seenSize1; ++s1) {
                    for (int s2 = 0; s2 < seenSize2; ++s2) {
                        this.ords.appendInt(Math.toIntExact(BlockHash.hashOrdToGroup(BytesRefLongBlockHash.this.finalHash.add(seen1[s1], seen2[s2]))));
                        this.addedValueInMultivaluePosition(p);
                    }
                }
                this.ords.endPositionEntry();
            }
            this.emitOrds();
        }
    }
}

