/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import java.util.List;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.blockhash.BooleanBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.BytesRefBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.BytesRefLongBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.DoubleBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.IntBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.LongBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.LongLongBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.NullBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.PackedValuesBlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.HashAggregationOperator;
import org.elasticsearch.core.Releasable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class BlockHash
implements Releasable,
SeenGroupIds {
    protected final BigArrays bigArrays;
    protected final BlockFactory blockFactory;

    BlockHash(DriverContext driverContext) {
        this.bigArrays = driverContext.bigArrays();
        this.blockFactory = driverContext.blockFactory();
    }

    public abstract void add(Page var1, GroupingAggregatorFunction.AddInput var2);

    public abstract Block[] getKeys();

    public abstract IntVector nonEmpty();

    @Override
    public abstract BitArray seenGroupIds(BigArrays var1);

    public static BlockHash build(List<HashAggregationOperator.GroupSpec> groups, DriverContext driverContext, int emitBatchSize, boolean allowBrokenOptimizations) {
        if (groups.size() == 1) {
            return BlockHash.newForElementType(groups.get(0).channel(), groups.get(0).elementType(), driverContext);
        }
        if (allowBrokenOptimizations && groups.size() == 2) {
            HashAggregationOperator.GroupSpec g1 = groups.get(0);
            HashAggregationOperator.GroupSpec g2 = groups.get(1);
            if (g1.elementType() == ElementType.LONG && g2.elementType() == ElementType.LONG) {
                return new LongLongBlockHash(driverContext, g1.channel(), g2.channel(), emitBatchSize);
            }
            if (g1.elementType() == ElementType.BYTES_REF && g2.elementType() == ElementType.LONG) {
                return new BytesRefLongBlockHash(driverContext, g1.channel(), g2.channel(), false, emitBatchSize);
            }
            if (g1.elementType() == ElementType.LONG && g2.elementType() == ElementType.BYTES_REF) {
                return new BytesRefLongBlockHash(driverContext, g2.channel(), g1.channel(), true, emitBatchSize);
            }
        }
        return new PackedValuesBlockHash(groups, driverContext, emitBatchSize);
    }

    private static BlockHash newForElementType(int channel, ElementType type, DriverContext driverContext) {
        return switch (type) {
            case ElementType.NULL -> new NullBlockHash(channel, driverContext);
            case ElementType.BOOLEAN -> new BooleanBlockHash(channel, driverContext);
            case ElementType.INT -> new IntBlockHash(channel, driverContext);
            case ElementType.LONG -> new LongBlockHash(channel, driverContext);
            case ElementType.DOUBLE -> new DoubleBlockHash(channel, driverContext);
            case ElementType.BYTES_REF -> new BytesRefBlockHash(channel, driverContext);
            default -> throw new IllegalArgumentException("unsupported grouping element type [" + type + "]");
        };
    }

    public static long hashOrdToGroup(long ord) {
        if (ord < 0L) {
            return -1L - ord;
        }
        return ord;
    }

    public static long hashOrdToGroupNullReserved(long ord) {
        return BlockHash.hashOrdToGroup(ord) + 1L;
    }
}

