/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.MissingHistoryOperationsException;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.GlobalCheckpointListeners;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RawIndexingDataTransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.action.TransportResumeFollowAction;

public class ShardChangesAction
extends ActionType<Response> {
    public static final ShardChangesAction INSTANCE = new ShardChangesAction();
    public static final String NAME = "indices:data/read/xpack/ccr/shard_changes";
    static final Translog.Operation[] EMPTY_OPERATIONS_ARRAY = new Translog.Operation[0];

    private ShardChangesAction() {
        super(NAME, Response::new);
    }

    private static void checkHistoryUUID(IndexShard indexShard, String expectedHistoryUUID) {
        String historyUUID = indexShard.getHistoryUUID();
        if (!historyUUID.equals(expectedHistoryUUID)) {
            throw new IllegalStateException("unexpected history uuid, expected [" + expectedHistoryUUID + "], actual [" + historyUUID + "]");
        }
    }

    static Translog.Operation[] getOperations(IndexShard indexShard, long globalCheckpoint, long fromSeqNo, int maxOperationCount, String expectedHistoryUUID, ByteSizeValue maxBatchSize) throws IOException {
        if (indexShard.state() != IndexShardState.STARTED) {
            throw new IndexShardNotStartedException(indexShard.shardId(), indexShard.state());
        }
        ShardChangesAction.checkHistoryUUID(indexShard, expectedHistoryUUID);
        if (fromSeqNo > globalCheckpoint) {
            throw new IllegalStateException("not exposing operations from [" + fromSeqNo + "] greater than the global checkpoint [" + globalCheckpoint + "]");
        }
        long seenBytes = 0L;
        long toSeqNo = Math.min(globalCheckpoint, fromSeqNo + (long)maxOperationCount - 1L);
        assert (fromSeqNo <= toSeqNo) : "invalid range from_seqno[" + fromSeqNo + "] > to_seqno[" + toSeqNo + "]";
        ArrayList<Translog.Operation> operations = new ArrayList<Translog.Operation>();
        try (Translog.Snapshot snapshot = indexShard.newChangesSnapshot("ccr", fromSeqNo, toSeqNo, true, true, false);){
            Translog.Operation op;
            while ((op = snapshot.next()) != null) {
                operations.add(op);
                if ((seenBytes += op.estimateSize()) <= maxBatchSize.getBytes()) continue;
                break;
            }
        }
        catch (MissingHistoryOperationsException e) {
            Collection retentionLeases = indexShard.getRetentionLeases().leases();
            String message = "Operations are no longer available for replicating. Existing retention leases [" + retentionLeases + "]; maybe increase the retention lease period setting [" + IndexSettings.INDEX_SOFT_DELETES_RETENTION_LEASE_PERIOD_SETTING.getKey() + "]?";
            ResourceNotFoundException wrapper = new ResourceNotFoundException(message, (Throwable)e, new Object[0]);
            wrapper.addMetadata("es.requested_operations_missing", new String[]{Long.toString(fromSeqNo), Long.toString(toSeqNo)});
            throw wrapper;
        }
        return operations.toArray(EMPTY_OPERATIONS_ARRAY);
    }

    static Response getResponse(long mappingVersion, long settingsVersion, long aliasesVersion, SeqNoStats seqNoStats, long maxSeqNoOfUpdates, Translog.Operation[] operations, long relativeStartNanos) {
        long tookInNanos = System.nanoTime() - relativeStartNanos;
        long tookInMillis = TimeUnit.NANOSECONDS.toMillis(tookInNanos);
        return new Response(mappingVersion, settingsVersion, aliasesVersion, seqNoStats.getGlobalCheckpoint(), seqNoStats.getMaxSeqNo(), maxSeqNoOfUpdates, operations, tookInMillis);
    }

    public static final class Response
    extends ActionResponse {
        private final long mappingVersion;
        private final long settingsVersion;
        private final long aliasesVersion;
        private final long globalCheckpoint;
        private final long maxSeqNo;
        private final long maxSeqNoOfUpdatesOrDeletes;
        private final Translog.Operation[] operations;
        private final long tookInMillis;

        public long getMappingVersion() {
            return this.mappingVersion;
        }

        public long getSettingsVersion() {
            return this.settingsVersion;
        }

        public long getAliasesVersion() {
            return this.aliasesVersion;
        }

        public long getGlobalCheckpoint() {
            return this.globalCheckpoint;
        }

        public long getMaxSeqNo() {
            return this.maxSeqNo;
        }

        public long getMaxSeqNoOfUpdatesOrDeletes() {
            return this.maxSeqNoOfUpdatesOrDeletes;
        }

        public Translog.Operation[] getOperations() {
            return this.operations;
        }

        public long getTookInMillis() {
            return this.tookInMillis;
        }

        Response(StreamInput in) throws IOException {
            super(in);
            this.mappingVersion = in.readVLong();
            this.settingsVersion = in.readVLong();
            this.aliasesVersion = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_3_0) ? in.readVLong() : 0L;
            this.globalCheckpoint = in.readZLong();
            this.maxSeqNo = in.readZLong();
            this.maxSeqNoOfUpdatesOrDeletes = in.readZLong();
            this.operations = (Translog.Operation[])in.readArray(Translog.Operation::readOperation, Translog.Operation[]::new);
            this.tookInMillis = in.readVLong();
        }

        Response(long mappingVersion, long settingsVersion, long aliasesVersion, long globalCheckpoint, long maxSeqNo, long maxSeqNoOfUpdatesOrDeletes, Translog.Operation[] operations, long tookInMillis) {
            this.mappingVersion = mappingVersion;
            this.settingsVersion = settingsVersion;
            this.aliasesVersion = aliasesVersion;
            this.globalCheckpoint = globalCheckpoint;
            this.maxSeqNo = maxSeqNo;
            this.maxSeqNoOfUpdatesOrDeletes = maxSeqNoOfUpdatesOrDeletes;
            this.operations = operations;
            this.tookInMillis = tookInMillis;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.mappingVersion);
            out.writeVLong(this.settingsVersion);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_3_0)) {
                out.writeVLong(this.aliasesVersion);
            }
            out.writeZLong(this.globalCheckpoint);
            out.writeZLong(this.maxSeqNo);
            out.writeZLong(this.maxSeqNoOfUpdatesOrDeletes);
            out.writeArray((Writeable[])this.operations);
            out.writeVLong(this.tookInMillis);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return this.mappingVersion == that.mappingVersion && this.settingsVersion == that.settingsVersion && this.aliasesVersion == that.aliasesVersion && this.globalCheckpoint == that.globalCheckpoint && this.maxSeqNo == that.maxSeqNo && this.maxSeqNoOfUpdatesOrDeletes == that.maxSeqNoOfUpdatesOrDeletes && Arrays.equals(this.operations, that.operations) && this.tookInMillis == that.tookInMillis;
        }

        public int hashCode() {
            return Objects.hash(this.mappingVersion, this.settingsVersion, this.aliasesVersion, this.globalCheckpoint, this.maxSeqNo, this.maxSeqNoOfUpdatesOrDeletes, Arrays.hashCode(this.operations), this.tookInMillis);
        }
    }

    public static class TransportAction
    extends TransportSingleShardAction<Request, Response> {
        private final IndicesService indicesService;

        @Inject
        public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
            super(ShardChangesAction.NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request::new, (Executor)threadPool.executor("search"));
            this.indicesService = indicesService;
        }

        protected Response shardOperation(Request request, ShardId shardId) throws IOException {
            IndexService indexService = this.indicesService.indexServiceSafe(request.getShard().getIndex());
            IndexShard indexShard = indexService.getShard(request.getShard().id());
            SeqNoStats seqNoStats = indexShard.seqNoStats();
            Translog.Operation[] operations = ShardChangesAction.getOperations(indexShard, seqNoStats.getGlobalCheckpoint(), request.getFromSeqNo(), request.getMaxOperationCount(), request.getExpectedHistoryUUID(), request.getMaxBatchSize());
            long maxSeqNoOfUpdatesOrDeletes = indexShard.getMaxSeqNoOfUpdatesOrDeletes();
            IndexMetadata indexMetadata = indexService.getMetadata();
            long mappingVersion = indexMetadata.getMappingVersion();
            long settingsVersion = indexMetadata.getSettingsVersion();
            long aliasesVersion = indexMetadata.getAliasesVersion();
            return ShardChangesAction.getResponse(mappingVersion, settingsVersion, aliasesVersion, seqNoStats, maxSeqNoOfUpdatesOrDeletes, operations, request.relativeStartNanos);
        }

        protected void asyncShardOperation(final Request request, final ShardId shardId, final ActionListener<Response> listener) throws IOException {
            IndexService indexService = this.indicesService.indexServiceSafe(request.getShard().getIndex());
            final IndexShard indexShard = indexService.getShard(request.getShard().id());
            SeqNoStats seqNoStats = indexShard.seqNoStats();
            if (request.getFromSeqNo() > seqNoStats.getGlobalCheckpoint()) {
                this.logger.trace("{} waiting for global checkpoint advancement from [{}] to [{}]", (Object)shardId, (Object)seqNoStats.getGlobalCheckpoint(), (Object)request.getFromSeqNo());
                indexShard.addGlobalCheckpointListener(request.getFromSeqNo(), new GlobalCheckpointListeners.GlobalCheckpointListener(){

                    public Executor executor() {
                        return threadPool.executor("ccr");
                    }

                    public void accept(long g, Exception e) {
                        if (g != -2L) {
                            assert (request.getFromSeqNo() <= g) : shardId + " only advanced to [" + g + "] while waiting for [" + request.getFromSeqNo() + "]";
                            this.globalCheckpointAdvanced(shardId, g, request, (ActionListener<Response>)listener);
                        } else {
                            assert (e != null);
                            this.globalCheckpointAdvancementFailure(shardId, e, request, (ActionListener<Response>)listener, indexShard);
                        }
                    }
                }, request.getPollTimeout());
            } else {
                super.asyncShardOperation((SingleShardRequest)request, shardId, listener);
            }
        }

        private void globalCheckpointAdvanced(ShardId shardId, long globalCheckpoint, Request request, ActionListener<Response> listener) {
            this.logger.trace("{} global checkpoint advanced to [{}] after waiting for [{}]", (Object)shardId, (Object)globalCheckpoint, (Object)request.getFromSeqNo());
            ActionListener.run(listener, l -> super.asyncShardOperation((SingleShardRequest)request, shardId, l));
        }

        private void globalCheckpointAdvancementFailure(ShardId shardId, Exception e, Request request, ActionListener<Response> listener, IndexShard indexShard) {
            this.logger.trace(() -> Strings.format((String)"%s exception waiting for global checkpoint advancement to [%s]", (Object[])new Object[]{shardId, request.getFromSeqNo()}), (Throwable)e);
            if (e instanceof TimeoutException) {
                try {
                    IndexMetadata indexMetadata = this.clusterService.state().metadata().index(shardId.getIndex());
                    if (indexMetadata == null) {
                        listener.onFailure((Exception)new IndexNotFoundException(shardId.getIndex()));
                        return;
                    }
                    ShardChangesAction.checkHistoryUUID(indexShard, request.expectedHistoryUUID);
                    long mappingVersion = indexMetadata.getMappingVersion();
                    long settingsVersion = indexMetadata.getSettingsVersion();
                    long aliasesVersion = indexMetadata.getAliasesVersion();
                    SeqNoStats latestSeqNoStats = indexShard.seqNoStats();
                    long maxSeqNoOfUpdatesOrDeletes = indexShard.getMaxSeqNoOfUpdatesOrDeletes();
                    listener.onResponse((Object)ShardChangesAction.getResponse(mappingVersion, settingsVersion, aliasesVersion, latestSeqNoStats, maxSeqNoOfUpdatesOrDeletes, EMPTY_OPERATIONS_ARRAY, request.relativeStartNanos));
                }
                catch (Exception caught) {
                    caught.addSuppressed(e);
                    listener.onFailure(caught);
                }
            } else {
                listener.onFailure(e);
            }
        }

        protected boolean resolveIndex(Request request) {
            return false;
        }

        protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
            return state.routingTable().shardRoutingTable(request.concreteIndex(), ((Request)request.request()).getShard().id()).activeInitializingShardsRandomIt();
        }

        protected Writeable.Reader<Response> getResponseReader() {
            return Response::new;
        }
    }

    public static class Request
    extends SingleShardRequest<Request>
    implements RawIndexingDataTransportRequest {
        private long fromSeqNo;
        private int maxOperationCount;
        private final ShardId shardId;
        private final String expectedHistoryUUID;
        private TimeValue pollTimeout = TransportResumeFollowAction.DEFAULT_READ_POLL_TIMEOUT;
        private ByteSizeValue maxBatchSize = TransportResumeFollowAction.DEFAULT_MAX_READ_REQUEST_SIZE;
        private long relativeStartNanos;

        public Request(ShardId shardId, String expectedHistoryUUID) {
            super(shardId.getIndexName());
            this.shardId = shardId;
            this.expectedHistoryUUID = expectedHistoryUUID;
        }

        Request(StreamInput in) throws IOException {
            super(in);
            this.fromSeqNo = in.readVLong();
            this.maxOperationCount = in.readVInt();
            this.shardId = new ShardId(in);
            this.expectedHistoryUUID = in.readString();
            this.pollTimeout = in.readTimeValue();
            this.maxBatchSize = ByteSizeValue.readFrom((StreamInput)in);
            this.relativeStartNanos = System.nanoTime();
        }

        public ShardId getShard() {
            return this.shardId;
        }

        public long getFromSeqNo() {
            return this.fromSeqNo;
        }

        public void setFromSeqNo(long fromSeqNo) {
            this.fromSeqNo = fromSeqNo;
        }

        public int getMaxOperationCount() {
            return this.maxOperationCount;
        }

        public void setMaxOperationCount(int maxOperationCount) {
            this.maxOperationCount = maxOperationCount;
        }

        public ByteSizeValue getMaxBatchSize() {
            return this.maxBatchSize;
        }

        public void setMaxBatchSize(ByteSizeValue maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        public String getExpectedHistoryUUID() {
            return this.expectedHistoryUUID;
        }

        public TimeValue getPollTimeout() {
            return this.pollTimeout;
        }

        public void setPollTimeout(TimeValue pollTimeout) {
            this.pollTimeout = Objects.requireNonNull(pollTimeout, "pollTimeout");
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.fromSeqNo < 0L) {
                validationException = ValidateActions.addValidationError((String)("fromSeqNo [" + this.fromSeqNo + "] cannot be lower than 0"), validationException);
            }
            if (this.maxOperationCount < 0) {
                validationException = ValidateActions.addValidationError((String)("maxOperationCount [" + this.maxOperationCount + "] cannot be lower than 0"), (ActionRequestValidationException)validationException);
            }
            if (this.maxBatchSize.compareTo(ByteSizeValue.ZERO) <= 0) {
                validationException = ValidateActions.addValidationError((String)("maxBatchSize [" + this.maxBatchSize.getStringRep() + "] must be larger than 0"), (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVLong(this.fromSeqNo);
            out.writeVInt(this.maxOperationCount);
            this.shardId.writeTo(out);
            out.writeString(this.expectedHistoryUUID);
            out.writeTimeValue(this.pollTimeout);
            this.maxBatchSize.writeTo(out);
        }

        public String getDescription() {
            return "shardId[" + this.shardId + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return this.fromSeqNo == request.fromSeqNo && this.maxOperationCount == request.maxOperationCount && Objects.equals(this.shardId, request.shardId) && Objects.equals(this.expectedHistoryUUID, request.expectedHistoryUUID) && Objects.equals(this.pollTimeout, request.pollTimeout) && this.maxBatchSize.equals((Object)request.maxBatchSize);
        }

        public int hashCode() {
            return Objects.hash(this.fromSeqNo, this.maxOperationCount, this.shardId, this.expectedHistoryUUID, this.pollTimeout, this.maxBatchSize);
        }

        public String toString() {
            return "Request{fromSeqNo=" + this.fromSeqNo + ", maxOperationCount=" + this.maxOperationCount + ", shardId=" + this.shardId + ", expectedHistoryUUID=" + this.expectedHistoryUUID + ", pollTimeout=" + this.pollTimeout + ", maxBatchSize=" + this.maxBatchSize.getStringRep() + "}";
        }
    }
}

