/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search.extractor;

import java.io.IOException;
import java.math.BigInteger;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.xpack.ql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.ql.index.VersionCompatibilityChecks;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypeConverter;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.common.io.SqlStreamInput;
import org.elasticsearch.xpack.sql.querydsl.container.GroupByRef;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;
import org.elasticsearch.xpack.sql.util.DateUtils;

public class CompositeKeyExtractor
implements BucketExtractor {
    static final String NAME = "k";
    private final String key;
    private final GroupByRef.Property property;
    private final ZoneId zoneId;
    private final DataType dataType;

    public CompositeKeyExtractor(String key, GroupByRef.Property property, ZoneId zoneId, DataType dataType) {
        this.key = key;
        this.property = property;
        this.zoneId = zoneId;
        this.dataType = dataType;
    }

    CompositeKeyExtractor(StreamInput in) throws IOException {
        this.key = in.readString();
        this.property = (GroupByRef.Property)in.readEnum(GroupByRef.Property.class);
        this.dataType = in.getTransportVersion().onOrAfter((VersionId)VersionCompatibilityChecks.INTRODUCING_UNSIGNED_LONG_TRANSPORT) ? SqlDataTypes.fromTypeName(in.readString()) : (in.readBoolean() ? DataTypes.DATETIME : DataTypes.NULL);
        this.zoneId = SqlStreamInput.asSqlStream(in).zoneId();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.key);
        out.writeEnum((Enum)this.property);
        if (out.getTransportVersion().onOrAfter((VersionId)VersionCompatibilityChecks.INTRODUCING_UNSIGNED_LONG_TRANSPORT)) {
            out.writeString(this.dataType.typeName());
        } else {
            out.writeBoolean(SqlDataTypes.isDateBased(this.dataType));
        }
    }

    String key() {
        return this.key;
    }

    GroupByRef.Property property() {
        return this.property;
    }

    ZoneId zoneId() {
        return this.zoneId;
    }

    public DataType dataType() {
        return this.dataType;
    }

    public String getWriteableName() {
        return NAME;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object extract(MultiBucketsAggregation.Bucket bucket) {
        void var3_6;
        if (this.property == GroupByRef.Property.COUNT) {
            return bucket.getDocCount();
        }
        Object m = bucket.getKey();
        if (!(m instanceof Map)) {
            throw new SqlIllegalArgumentException("Unexpected bucket returned: {}", m);
        }
        Object v = ((Map)m).get(this.key);
        if (v == null) return var3_6;
        if (SqlDataTypes.isDateBased(this.dataType)) {
            if (!(v instanceof Long)) throw new SqlIllegalArgumentException("Invalid date key returned: {}", v);
            Long l = (Long)v;
            ZonedDateTime zonedDateTime = DateUtils.asDateTimeWithMillis(l, this.zoneId);
            return var3_6;
        } else {
            if (this.dataType != DataTypes.UNSIGNED_LONG) return var3_6;
            if (!(v instanceof Number)) throw new SqlIllegalArgumentException("Invalid unsigned_long key returned: {}", v);
            Number number = (Number)v;
            BigInteger bigInteger = DataTypeConverter.toUnsignedLong((Number)number);
        }
        return var3_6;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.property, this.zoneId, this.dataType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeKeyExtractor other = (CompositeKeyExtractor)obj;
        return Objects.equals(this.key, other.key) && Objects.equals((Object)this.property, (Object)other.property) && Objects.equals(this.zoneId, other.zoneId) && Objects.equals(this.dataType, other.dataType);
    }

    public String toString() {
        return "|" + this.key + "|";
    }
}

