/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.StringUtils;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;

public class StringContainsFunctionProcessor
implements Processor {
    public static final String NAME = "sstc";
    private final Processor string;
    private final Processor substring;
    private final boolean caseInsensitive;

    public StringContainsFunctionProcessor(Processor string, Processor substring, boolean caseInsensitive) {
        this.string = string;
        this.substring = substring;
        this.caseInsensitive = caseInsensitive;
    }

    public StringContainsFunctionProcessor(StreamInput in) throws IOException {
        this.string = (Processor)in.readNamedWriteable(Processor.class);
        this.substring = (Processor)in.readNamedWriteable(Processor.class);
        this.caseInsensitive = in.readBoolean();
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.string);
        out.writeNamedWriteable((NamedWriteable)this.substring);
        out.writeBoolean(this.caseInsensitive);
    }

    public Object process(Object input) {
        return StringContainsFunctionProcessor.doProcess(this.string.process(input), this.substring.process(input), this.caseInsensitive);
    }

    public static Object doProcess(Object string, Object substring, boolean caseInsensitive) {
        if (string == null) {
            return null;
        }
        StringContainsFunctionProcessor.throwIfNotString(string);
        StringContainsFunctionProcessor.throwIfNotString(substring);
        String strString = string.toString();
        String strSubstring = substring.toString();
        return StringUtils.stringContains(strString, strSubstring, caseInsensitive);
    }

    private static void throwIfNotString(Object obj) {
        if (!(obj instanceof String || obj instanceof Character)) {
            throw new EqlIllegalArgumentException("A string/char is required; received [{}]", obj);
        }
    }

    protected Processor string() {
        return this.string;
    }

    public Processor substring() {
        return this.substring;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StringContainsFunctionProcessor other = (StringContainsFunctionProcessor)obj;
        return Objects.equals(this.string(), other.string()) && Objects.equals(this.substring(), other.substring());
    }

    public int hashCode() {
        return Objects.hash(this.string(), this.substring());
    }

    public String getWriteableName() {
        return NAME;
    }
}

