/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.fleet.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.fleet.action.PostSecretRequest;
import org.elasticsearch.xpack.fleet.action.PostSecretResponse;

public class TransportPostSecretAction
extends HandledTransportAction<PostSecretRequest, PostSecretResponse> {
    private final Client client;

    @Inject
    public TransportPostSecretAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/fleet/secrets/post", transportService, actionFilters, PostSecretRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = new OriginSettingClient(client, "fleet");
    }

    protected void doExecute(Task task, PostSecretRequest request, ActionListener<PostSecretResponse> listener) {
        try {
            this.client.prepareIndex(".fleet-secrets").setSource(request.toXContent(XContentFactory.jsonBuilder())).execute(listener.delegateFailureAndWrap((l, indexResponse) -> l.onResponse((Object)new PostSecretResponse(indexResponse.getId()))));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

