/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.rest.RestStatus;

class HttpClient {
    HttpClient() {
    }

    byte[] getBytes(String url) throws IOException {
        return this.get(url).readAllBytes();
    }

    InputStream get(String urlToGet) throws IOException {
        return (InputStream)HttpClient.doPrivileged(() -> {
            String url = urlToGet;
            HttpURLConnection conn = HttpClient.createConnection(url);
            int redirectsCount = 0;
            block5: while (true) {
                switch (conn.getResponseCode()) {
                    case 200: {
                        return new BufferedInputStream(HttpClient.getInputStream(conn));
                    }
                    case 301: 
                    case 302: 
                    case 303: {
                        if (redirectsCount++ > 50) {
                            throw new IllegalStateException("too many redirects connection to [" + urlToGet + "]");
                        }
                        String location = conn.getHeaderField("Location");
                        URL base = new URL(url);
                        URL next = new URL(base, location);
                        url = next.toExternalForm();
                        conn = HttpClient.createConnection(url);
                        continue block5;
                    }
                    case 404: {
                        throw new ResourceNotFoundException("{} not found", new Object[]{urlToGet});
                    }
                }
                break;
            }
            int responseCode = conn.getResponseCode();
            throw new ElasticsearchStatusException("error during downloading {}", RestStatus.fromCode((int)responseCode), new Object[]{urlToGet});
        });
    }

    @SuppressForbidden(reason="we need socket connection to download data from internet")
    private static InputStream getInputStream(HttpURLConnection conn) throws IOException {
        return conn.getInputStream();
    }

    private static HttpURLConnection createConnection(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        conn.setDoOutput(false);
        conn.setInstanceFollowRedirects(false);
        return conn;
    }

    private static <R> R doPrivileged(CheckedSupplier<R, IOException> supplier) throws IOException {
        SpecialPermission.check();
        try {
            return (R)AccessController.doPrivileged(() -> supplier.get());
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }
}

