/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.type;

import java.util.Collection;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypeRegistry;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class EsqlDataTypeRegistry
implements DataTypeRegistry {
    public static final DataTypeRegistry INSTANCE = new EsqlDataTypeRegistry();

    private EsqlDataTypeRegistry() {
    }

    public Collection<DataType> dataTypes() {
        return EsqlDataTypes.types();
    }

    public DataType fromEs(String typeName, TimeSeriesParams.MetricType metricType) {
        if (metricType == TimeSeriesParams.MetricType.COUNTER) {
            return DataTypes.UNSUPPORTED;
        }
        return EsqlDataTypes.fromName(typeName);
    }

    public DataType fromJava(Object value) {
        return EsqlDataTypes.fromJava(value);
    }

    public boolean isUnsupported(DataType type) {
        return EsqlDataTypes.isUnsupported(type);
    }

    public boolean canConvert(DataType from, DataType to) {
        return EsqlDataTypeConverter.canConvert(from, to);
    }

    public Object convert(Object value, DataType type) {
        return EsqlDataTypeConverter.convert(value, type);
    }

    public DataType commonType(DataType left, DataType right) {
        if (DataTypes.isDateTime((DataType)left) && EsqlDataTypes.isTemporalAmount(right) || EsqlDataTypes.isTemporalAmount(left) && DataTypes.isDateTime((DataType)right)) {
            return DataTypes.DATETIME;
        }
        if (left == EsqlDataTypes.TIME_DURATION && right == EsqlDataTypes.TIME_DURATION) {
            return EsqlDataTypes.TIME_DURATION;
        }
        if (left == EsqlDataTypes.DATE_PERIOD && right == EsqlDataTypes.DATE_PERIOD) {
            return EsqlDataTypes.DATE_PERIOD;
        }
        return EsqlDataTypeConverter.commonType(left, right);
    }
}

