/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.type;

import java.io.IOException;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.InvalidArgumentException;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.Converter;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypeConverter;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class EsqlDataTypeConverter {
    public static boolean canConvert(DataType from, DataType to) {
        if (from == to || from == DataTypes.NULL) {
            return true;
        }
        return DataTypes.isPrimitive((DataType)from) && DataTypes.isPrimitive((DataType)to) && EsqlDataTypeConverter.converterFor(from, to) != null;
    }

    public static Converter converterFor(DataType from, DataType to) {
        Converter converter = DataTypeConverter.converterFor((DataType)from, (DataType)to);
        if (converter != null) {
            return converter;
        }
        if (DataTypes.isString((DataType)from) && to == EsqlDataTypes.TIME_DURATION) {
            return EsqlConverter.STRING_TO_TIME_DURATION;
        }
        if (DataTypes.isString((DataType)from) && to == EsqlDataTypes.DATE_PERIOD) {
            return EsqlConverter.STRING_TO_DATE_PERIOD;
        }
        return null;
    }

    public static TemporalAmount parseTemporalAmount(Object val, DataType expectedType) {
        Object errorMessage = "Cannot parse [{}] to {}";
        String str = String.valueOf(val);
        if (str == null) {
            return null;
        }
        StringBuilder value = new StringBuilder();
        StringBuilder qualifier = new StringBuilder();
        StringBuilder nextBuffer = value;
        boolean lastWasSpace = false;
        for (char c : str.trim().toCharArray()) {
            if (c == ' ') {
                if (!lastWasSpace) {
                    nextBuffer = nextBuffer == value ? qualifier : null;
                }
                lastWasSpace = true;
                continue;
            }
            if (nextBuffer == null) {
                throw new ParsingException(Source.EMPTY, (String)errorMessage, val, expectedType);
            }
            nextBuffer.append(c);
            lastWasSpace = false;
        }
        if (!(value.isEmpty() || qualifier.isEmpty())) {
            try {
                TemporalAmount result = EsqlDataTypeConverter.parseTemporalAmout(Integer.parseInt(value.toString()), qualifier.toString(), Source.EMPTY);
                if (EsqlDataTypes.DATE_PERIOD == expectedType && result instanceof Period || EsqlDataTypes.TIME_DURATION == expectedType && result instanceof Duration) {
                    return result;
                }
                if (result instanceof Period && expectedType == EsqlDataTypes.TIME_DURATION) {
                    errorMessage = (String)errorMessage + ", did you mean " + EsqlDataTypes.DATE_PERIOD + "?";
                }
                if (result instanceof Duration && expectedType == EsqlDataTypes.DATE_PERIOD) {
                    errorMessage = (String)errorMessage + ", did you mean " + EsqlDataTypes.TIME_DURATION + "?";
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ParsingException(Source.EMPTY, (String)errorMessage, val, expectedType);
    }

    public static Object convert(Object value, DataType dataType) {
        DataType detectedType = EsqlDataTypes.fromJava(value);
        if (detectedType == dataType || value == null) {
            return value;
        }
        Converter converter = EsqlDataTypeConverter.converterFor(detectedType, dataType);
        if (converter == null) {
            throw new QlIllegalArgumentException("cannot convert from [{}], type [{}] to [{}]", new Object[]{value, detectedType.typeName(), dataType.typeName()});
        }
        return converter.convert(value);
    }

    public static DataType commonType(DataType left, DataType right) {
        return DataTypeConverter.commonType((DataType)left, (DataType)right);
    }

    public static TemporalAmount parseTemporalAmout(Number value, String qualifier, Source source) throws InvalidArgumentException, ArithmeticException, ParsingException {
        return switch (qualifier) {
            case "millisecond", "milliseconds" -> Duration.ofMillis(DataTypeConverter.safeToLong((Number)value));
            case "second", "seconds" -> Duration.ofSeconds(DataTypeConverter.safeToLong((Number)value));
            case "minute", "minutes" -> Duration.ofMinutes(DataTypeConverter.safeToLong((Number)value));
            case "hour", "hours" -> Duration.ofHours(DataTypeConverter.safeToLong((Number)value));
            case "day", "days" -> Period.ofDays(DataTypeConverter.safeToInt((long)DataTypeConverter.safeToLong((Number)value)));
            case "week", "weeks" -> Period.ofWeeks(DataTypeConverter.safeToInt((long)DataTypeConverter.safeToLong((Number)value)));
            case "month", "months" -> Period.ofMonths(DataTypeConverter.safeToInt((long)DataTypeConverter.safeToLong((Number)value)));
            case "year", "years" -> Period.ofYears(DataTypeConverter.safeToInt((long)DataTypeConverter.safeToLong((Number)value)));
            default -> throw new ParsingException(source, "Unexpected time interval qualifier: '{}'", qualifier);
        };
    }

    public static enum EsqlConverter implements Converter
    {
        STRING_TO_DATE_PERIOD(x -> EsqlDataTypeConverter.parseTemporalAmount(x, EsqlDataTypes.DATE_PERIOD)),
        STRING_TO_TIME_DURATION(x -> EsqlDataTypeConverter.parseTemporalAmount(x, EsqlDataTypes.TIME_DURATION));

        private static final String NAME = "esql-converter";
        private final Function<Object, Object> converter;

        private EsqlConverter(Function<Object, Object> converter) {
            this.converter = converter;
        }

        public String getWriteableName() {
            return NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        public static Converter read(StreamInput in) throws IOException {
            return (Converter)in.readEnum(EsqlConverter.class);
        }

        public Object convert(Object l) {
            if (l == null) {
                return null;
            }
            return this.converter.apply(l);
        }
    }
}

