/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class EvalExec
extends UnaryExec
implements EstimatesRowSize {
    private final List<Alias> fields;

    public EvalExec(Source source, PhysicalPlan child, List<Alias> fields) {
        super(source, child);
        this.fields = fields;
    }

    public List<Alias> fields() {
        return this.fields;
    }

    @Override
    public List<Attribute> output() {
        return NamedExpressions.mergeOutputAttributes(this.fields, this.child().output());
    }

    @Override
    public UnaryExec replaceChild(PhysicalPlan newChild) {
        return new EvalExec(this.source(), newChild, this.fields);
    }

    protected NodeInfo<? extends PhysicalPlan> info() {
        return NodeInfo.create((Node)this, EvalExec::new, (Object)((Object)this.child()), this.fields);
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        state.add(false, this.fields);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvalExec eval = (EvalExec)o;
        return this.child().equals((Object)eval.child()) && Objects.equals(this.fields, eval.fields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fields);
    }
}

