/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.plan.physical.LeafExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.index.EsIndex;
import org.elasticsearch.xpack.ql.plan.logical.EsRelation;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.NodeUtils;
import org.elasticsearch.xpack.ql.tree.Source;

public class EsSourceExec
extends LeafExec {
    private final EsIndex index;
    private final List<Attribute> attributes;
    private final QueryBuilder query;

    public EsSourceExec(EsRelation relation) {
        this(relation.source(), relation.index(), relation.output(), null);
    }

    public EsSourceExec(Source source, EsIndex index, List<Attribute> attributes, QueryBuilder query) {
        super(source);
        this.index = index;
        this.attributes = attributes;
        this.query = query;
    }

    public EsIndex index() {
        return this.index;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public List<Attribute> output() {
        return this.attributes;
    }

    protected NodeInfo<? extends PhysicalPlan> info() {
        return NodeInfo.create((Node)this, EsSourceExec::new, (Object)this.index, this.attributes, (Object)this.query);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EsSourceExec other = (EsSourceExec)((Object)obj);
        return Objects.equals(this.index, other.index) && Objects.equals(this.query, other.query);
    }

    public String nodeString() {
        return this.nodeName() + "[" + this.index + "]" + NodeUtils.limitedToString(this.attributes);
    }
}

