/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import java.util.List;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.esql.parser.AbstractBuilder;
import org.elasticsearch.xpack.esql.parser.EsqlBaseParser;
import org.elasticsearch.xpack.ql.parser.ParserUtils;

abstract class IdentifierBuilder
extends AbstractBuilder {
    IdentifierBuilder() {
    }

    @Override
    public String visitIdentifier(EsqlBaseParser.IdentifierContext ctx) {
        return IdentifierBuilder.unquoteIdentifier(ctx.QUOTED_IDENTIFIER(), ctx.UNQUOTED_IDENTIFIER());
    }

    @Override
    public String visitSourceIdentifier(EsqlBaseParser.SourceIdentifierContext ctx) {
        return IdentifierBuilder.unquoteIdentifier(ctx.SRC_QUOTED_IDENTIFIER(), ctx.SRC_UNQUOTED_IDENTIFIER());
    }

    private static String unquoteIdentifier(TerminalNode quotedNode, TerminalNode unquotedNode) {
        String result;
        if (quotedNode != null) {
            String identifier = quotedNode.getText();
            result = identifier.substring(1, identifier.length() - 1);
        } else {
            result = unquotedNode.getText();
        }
        return result;
    }

    public String visitSourceIdentifiers(List<EsqlBaseParser.SourceIdentifierContext> ctx) {
        return Strings.collectionToDelimitedString((Iterable)ParserUtils.visitList((ParseTreeVisitor)this, ctx, String.class), (String)",");
    }
}

