/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import java.io.IOException;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeRegistry;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.ArithmeticOperation;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.BinaryArithmeticOperation;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

abstract class EsqlArithmeticOperation
extends ArithmeticOperation
implements EvaluatorMapper {
    private final ArithmeticEvaluator ints;
    private final ArithmeticEvaluator longs;
    private final ArithmeticEvaluator ulongs;
    private final ArithmeticEvaluator doubles;
    private DataType dataType;

    EsqlArithmeticOperation(Source source, Expression left, Expression right, OperationSymbol op, ArithmeticEvaluator ints, ArithmeticEvaluator longs, ArithmeticEvaluator ulongs, ArithmeticEvaluator doubles) {
        super(source, left, right, (BinaryArithmeticOperation)op);
        this.ints = ints;
        this.longs = longs;
        this.ulongs = ulongs;
        this.doubles = doubles;
    }

    @Override
    public Object fold() {
        return EvaluatorMapper.super.fold();
    }

    public DataType dataType() {
        if (this.dataType == null) {
            this.dataType = EsqlDataTypeRegistry.INSTANCE.commonType(this.left().dataType(), this.right().dataType());
        }
        return this.dataType;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        DataType commonType = this.dataType();
        DataType leftType = this.left().dataType();
        if (leftType.isNumeric()) {
            ArithmeticEvaluator eval;
            EvalOperator.ExpressionEvaluator.Factory lhs = Cast.cast(this.source(), this.left().dataType(), commonType, toEvaluator.apply(this.left()));
            EvalOperator.ExpressionEvaluator.Factory rhs = Cast.cast(this.source(), this.right().dataType(), commonType, toEvaluator.apply(this.right()));
            if (commonType == DataTypes.INTEGER) {
                eval = this.ints;
            } else if (commonType == DataTypes.LONG) {
                eval = this.longs;
            } else if (commonType == DataTypes.UNSIGNED_LONG) {
                eval = this.ulongs;
            } else if (commonType == DataTypes.DOUBLE) {
                eval = this.doubles;
            } else {
                throw new EsqlIllegalArgumentException("Unsupported type " + commonType);
            }
            return eval.apply(this.source(), lhs, rhs);
        }
        throw new EsqlIllegalArgumentException("Unsupported type " + leftType);
    }

    static interface ArithmeticEvaluator {
        public EvalOperator.ExpressionEvaluator.Factory apply(Source var1, EvalOperator.ExpressionEvaluator.Factory var2, EvalOperator.ExpressionEvaluator.Factory var3);
    }

    static enum OperationSymbol implements BinaryArithmeticOperation
    {
        ADD("+"),
        SUB("-"),
        MUL("*"),
        DIV("/"),
        MOD("%");

        private final String symbol;

        private OperationSymbol(String symbol) {
            this.symbol = symbol;
        }

        public String getWriteableName() {
            throw new UnsupportedOperationException();
        }

        public void writeTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Object doApply(Object o, Object o2) {
            throw new UnsupportedOperationException();
        }

        public String symbol() {
            return this.symbol;
        }
    }
}

