/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMinBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMinBytesRefEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMinDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMinIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMinLongEvaluator;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class MvMin
extends AbstractMultivalueFunction {
    @FunctionInfo(returnType={"?"}, description="Reduce a multivalued field to a single valued field containing the minimum value.")
    public MvMin(Source source, @Param(name="v", type={"unsigned_long", "date", "boolean", "double", "ip", "text", "integer", "keyword", "version", "long"}) Expression field) {
        super(source, field);
    }

    @Override
    protected Expression.TypeResolution resolveFieldType() {
        return TypeResolutions.isType((Expression)this.field(), t -> !EsqlDataTypes.isSpatial(t) && EsqlDataTypes.isRepresentable(t), (String)this.sourceText(), null, (String[])new String[]{"representableNonSpatial"});
    }

    @Override
    protected EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory fieldEval) {
        return switch (PlannerUtils.toSortableElementType(this.field().dataType())) {
            case ElementType.BOOLEAN -> new MvMinBooleanEvaluator.Factory(fieldEval);
            case ElementType.BYTES_REF -> new MvMinBytesRefEvaluator.Factory(fieldEval);
            case ElementType.DOUBLE -> new MvMinDoubleEvaluator.Factory(fieldEval);
            case ElementType.INT -> new MvMinIntEvaluator.Factory(fieldEval);
            case ElementType.LONG -> new MvMinLongEvaluator.Factory(fieldEval);
            case ElementType.NULL -> EvalOperator.CONSTANT_NULL_FACTORY;
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.field.dataType());
        };
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvMin(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvMin::new, (Object)this.field());
    }

    static boolean process(boolean current, boolean v) {
        return current && v;
    }

    static void process(BytesRef current, BytesRef v) {
        if (v.compareTo(current) < 0) {
            current.bytes = v.bytes;
            current.offset = v.offset;
            current.length = v.length;
        }
    }

    static double process(double current, double v) {
        return Math.min(current, v);
    }

    static int process(int current, int v) {
        return Math.min(current, v);
    }

    static long process(long current, long v) {
        return Math.min(current, v);
    }

    static int ascendingIndex(int count) {
        return 0;
    }
}

