/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.util.List;
import java.util.Map;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDoubleFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDoubleFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDoubleFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToRadiansEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class ToRadians
extends AbstractConvertFunction
implements EvaluatorMapper {
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataTypes.DOUBLE, ToRadiansEvaluator.Factory::new), Map.entry(DataTypes.INTEGER, (field, source) -> new ToRadiansEvaluator.Factory(new ToDoubleFromIntEvaluator.Factory(field, source), source)), Map.entry(DataTypes.LONG, (field, source) -> new ToRadiansEvaluator.Factory(new ToDoubleFromLongEvaluator.Factory(field, source), source)), Map.entry(DataTypes.UNSIGNED_LONG, (field, source) -> new ToRadiansEvaluator.Factory(new ToDoubleFromUnsignedLongEvaluator.Factory(field, source), source)));

    @FunctionInfo(returnType={"double"})
    public ToRadians(Source source, @Param(name="v", type={"double", "long", "unsigned_long", "integer"}) Expression field) {
        super(source, field);
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToRadians(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToRadians::new, (Object)this.field());
    }

    @Override
    public DataType dataType() {
        return DataTypes.DOUBLE;
    }

    static double process(double deg) {
        return Math.toRadians(deg);
    }
}

