/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.scheduling;

import java.util.Objects;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.transform.Transform;
import org.elasticsearch.xpack.transform.transforms.scheduling.TransformScheduler;
import org.elasticsearch.xpack.transform.transforms.scheduling.TransformSchedulingUtils;

final class TransformScheduledTask {
    private final String transformId;
    private final TimeValue frequency;
    private final Long lastTriggeredTimeMillis;
    private final int failureCount;
    private final long nextScheduledTimeMillis;
    private final TransformScheduler.Listener listener;

    TransformScheduledTask(String transformId, TimeValue frequency, Long lastTriggeredTimeMillis, int failureCount, long nextScheduledTimeMillis, TransformScheduler.Listener listener) {
        this.transformId = Objects.requireNonNull(transformId);
        this.frequency = frequency != null ? frequency : Transform.DEFAULT_TRANSFORM_FREQUENCY;
        this.lastTriggeredTimeMillis = lastTriggeredTimeMillis;
        this.failureCount = failureCount;
        this.nextScheduledTimeMillis = nextScheduledTimeMillis;
        this.listener = Objects.requireNonNull(listener);
    }

    TransformScheduledTask(String transformId, TimeValue frequency, Long lastTriggeredTimeMillis, int failureCount, TransformScheduler.Listener listener) {
        this(transformId, frequency, lastTriggeredTimeMillis, failureCount, TransformSchedulingUtils.calculateNextScheduledTime(lastTriggeredTimeMillis, frequency, failureCount), listener);
    }

    String getTransformId() {
        return this.transformId;
    }

    TimeValue getFrequency() {
        return this.frequency;
    }

    Long getLastTriggeredTimeMillis() {
        return this.lastTriggeredTimeMillis;
    }

    int getFailureCount() {
        return this.failureCount;
    }

    long getNextScheduledTimeMillis() {
        return this.nextScheduledTimeMillis;
    }

    TransformScheduler.Listener getListener() {
        return this.listener;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformScheduledTask that = (TransformScheduledTask)other;
        return Objects.equals(this.transformId, that.transformId) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.lastTriggeredTimeMillis, that.lastTriggeredTimeMillis) && this.failureCount == that.failureCount && this.nextScheduledTimeMillis == that.nextScheduledTimeMillis && this.listener == that.listener;
    }

    public int hashCode() {
        return Objects.hash(this.transformId, this.frequency, this.lastTriggeredTimeMillis, this.failureCount, this.nextScheduledTimeMillis, System.identityHashCode(this.listener));
    }

    public String toString() {
        return "TransformScheduledTask[" + "transformId=" + this.transformId + ",frequency=" + this.frequency + ",lastTriggeredTimeMillis=" + this.lastTriggeredTimeMillis + ",failureCount=" + this.failureCount + ",nextScheduledTimeMillis=" + this.nextScheduledTimeMillis + ",listener=" + this.listener + "]";
    }
}

