/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.common;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.SourceConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;
import org.elasticsearch.xpack.transform.transforms.Function;
import org.elasticsearch.xpack.transform.transforms.common.DocumentConversionUtils;
import org.elasticsearch.xpack.transform.transforms.pivot.AggregationResultUtils;

public abstract class AbstractCompositeAggFunction
implements Function {
    public static final int TEST_QUERY_PAGE_SIZE = 50;
    public static final String COMPOSITE_AGGREGATION_NAME = "_transform";
    private final CompositeAggregationBuilder cachedCompositeAggregation;

    public AbstractCompositeAggFunction(CompositeAggregationBuilder compositeAggregationBuilder) {
        this.cachedCompositeAggregation = compositeAggregationBuilder;
    }

    @Override
    public SearchSourceBuilder buildSearchQuery(SearchSourceBuilder builder, Map<String, Object> position, int pageSize) {
        this.cachedCompositeAggregation.aggregateAfter(position);
        this.cachedCompositeAggregation.size(pageSize);
        return builder.size(0).aggregation((AggregationBuilder)this.cachedCompositeAggregation);
    }

    @Override
    public void preview(Client client, TimeValue timeout, Map<String, String> headers, SourceConfig sourceConfig, Map<String, String> fieldTypeMap, int numberOfBuckets, ActionListener<List<Map<String, Object>>> listener) {
        ClientHelper.assertNoAuthorizationHeader(headers);
        ClientHelper.executeWithHeadersAsync(headers, (String)"transform", (Client)client, (ActionType)TransportSearchAction.TYPE, (ActionRequest)this.buildSearchRequest(sourceConfig, timeout, numberOfBuckets), (ActionListener)ActionListener.wrap(r -> {
            try {
                Aggregations aggregations = r.getAggregations();
                if (aggregations == null) {
                    listener.onFailure((Exception)new ElasticsearchStatusException("Source indices have been deleted or closed.", RestStatus.BAD_REQUEST, new Object[0]));
                    return;
                }
                CompositeAggregation agg = (CompositeAggregation)aggregations.get(COMPOSITE_AGGREGATION_NAME);
                if (agg == null || agg.getBuckets().isEmpty()) {
                    listener.onResponse(Collections.emptyList());
                    return;
                }
                TransformIndexerStats stats = new TransformIndexerStats();
                TransformProgress progress = new TransformProgress();
                List docs = this.extractResults(agg, fieldTypeMap, stats, progress).map(this::documentTransformationFunction).collect(Collectors.toList());
                listener.onResponse(docs);
            }
            catch (AggregationResultUtils.AggregationExtractionException extractionException) {
                listener.onFailure((Exception)new ElasticsearchStatusException(extractionException.getMessage(), RestStatus.BAD_REQUEST, new Object[0]));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void validateQuery(Client client, Map<String, String> headers, SourceConfig sourceConfig, TimeValue timeout, ActionListener<Boolean> listener) {
        SearchRequest searchRequest = this.buildSearchRequest(sourceConfig, timeout, 50);
        ClientHelper.executeWithHeadersAsync(headers, (String)"transform", (Client)client, (ActionType)TransportSearchAction.TYPE, (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            if (response == null) {
                listener.onFailure((Exception)new ValidationException().addValidationError("Unexpected null response from test query"));
                return;
            }
            if (response.status() != RestStatus.OK) {
                listener.onFailure((Exception)new ValidationException().addValidationError(Strings.format((String)"Unexpected status from response of test query: %s", (Object[])new Object[]{response.status()})));
                return;
            }
            listener.onResponse((Object)true);
        }, e -> {
            Throwable unwrapped = ExceptionsHelper.unwrapCause((Throwable)e);
            RestStatus status = unwrapped instanceof ElasticsearchException ? ((ElasticsearchException)unwrapped).status() : RestStatus.SERVICE_UNAVAILABLE;
            listener.onFailure((Exception)new ValidationException(unwrapped).addValidationError(Strings.format((String)"Failed to test query, received status: %s", (Object[])new Object[]{status})));
        }));
    }

    @Override
    public Tuple<Stream<IndexRequest>, Map<String, Object>> processSearchResponse(SearchResponse searchResponse, String destinationIndex, String destinationPipeline, Map<String, String> fieldTypeMap, TransformIndexerStats stats, TransformProgress progress) {
        Aggregations aggregations = searchResponse.getAggregations();
        if (aggregations == null) {
            return null;
        }
        CompositeAggregation compositeAgg = (CompositeAggregation)aggregations.get(COMPOSITE_AGGREGATION_NAME);
        if (compositeAgg == null || compositeAgg.afterKey() == null) {
            return null;
        }
        Stream<IndexRequest> indexRequestStream = this.extractResults(compositeAgg, fieldTypeMap, stats, progress).map(doc -> {
            String docId = (String)doc.remove(TransformField.DOCUMENT_ID_FIELD);
            return DocumentConversionUtils.convertDocumentToIndexRequest(docId, this.documentTransformationFunction((Map<String, Object>)doc), destinationIndex, destinationPipeline);
        });
        return Tuple.tuple(indexRequestStream, (Object)compositeAgg.afterKey());
    }

    protected abstract Map<String, Object> documentTransformationFunction(Map<String, Object> var1);

    protected abstract Stream<Map<String, Object>> extractResults(CompositeAggregation var1, Map<String, String> var2, TransformIndexerStats var3, TransformProgress var4);

    private SearchRequest buildSearchRequest(SourceConfig sourceConfig, TimeValue timeout, int pageSize) {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query(sourceConfig.getQueryConfig().getQuery()).runtimeMappings(sourceConfig.getRuntimeMappings()).timeout(timeout);
        this.buildSearchQuery(sourceBuilder, null, pageSize);
        return new SearchRequest(sourceConfig.getIndex()).source(sourceBuilder).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
    }

    @Override
    public void getInitialProgressFromResponse(SearchResponse response, ActionListener<TransformProgress> progressListener) {
        progressListener.onResponse((Object)new TransformProgress(Long.valueOf(response.getHits().getTotalHits().value), Long.valueOf(0L), Long.valueOf(0L)));
    }
}

