/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureTransportAction;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;

public class TransformInfoTransportAction
extends XPackInfoFeatureTransportAction {
    private static final Logger logger = LogManager.getLogger(TransformInfoTransportAction.class);
    public static final String[] PROVIDED_STATS = new String[]{TransformIndexerStats.NUM_PAGES.getPreferredName(), TransformIndexerStats.NUM_INPUT_DOCUMENTS.getPreferredName(), TransformIndexerStats.NUM_OUTPUT_DOCUMENTS.getPreferredName(), TransformIndexerStats.NUM_DELETED_DOCUMENTS.getPreferredName(), TransformIndexerStats.NUM_INVOCATIONS.getPreferredName(), TransformIndexerStats.INDEX_TIME_IN_MS.getPreferredName(), TransformIndexerStats.SEARCH_TIME_IN_MS.getPreferredName(), TransformIndexerStats.PROCESSING_TIME_IN_MS.getPreferredName(), TransformIndexerStats.DELETE_TIME_IN_MS.getPreferredName(), TransformIndexerStats.INDEX_TOTAL.getPreferredName(), TransformIndexerStats.SEARCH_TOTAL.getPreferredName(), TransformIndexerStats.PROCESSING_TOTAL.getPreferredName(), TransformIndexerStats.INDEX_FAILURES.getPreferredName(), TransformIndexerStats.SEARCH_FAILURES.getPreferredName(), TransformIndexerStats.EXPONENTIAL_AVG_CHECKPOINT_DURATION_MS.getPreferredName(), TransformIndexerStats.EXPONENTIAL_AVG_DOCUMENTS_INDEXED.getPreferredName(), TransformIndexerStats.EXPONENTIAL_AVG_DOCUMENTS_PROCESSED.getPreferredName()};

    @Inject
    public TransformInfoTransportAction(TransportService transportService, ActionFilters actionFilters) {
        super(XPackInfoFeatureAction.TRANSFORM.name(), transportService, actionFilters);
    }

    public String name() {
        return "transform";
    }

    public boolean available() {
        return true;
    }

    public boolean enabled() {
        return true;
    }

    static TransformIndexerStats parseSearchAggs(SearchResponse searchResponse) {
        ArrayList<Double> statisticsList = new ArrayList<Double>(PROVIDED_STATS.length);
        for (String statName : PROVIDED_STATS) {
            Aggregation agg = searchResponse.getAggregations().get(statName);
            if (agg instanceof NumericMetricsAggregation.SingleValue) {
                statisticsList.add(((NumericMetricsAggregation.SingleValue)agg).value());
                continue;
            }
            statisticsList.add(0.0);
        }
        return new TransformIndexerStats(((Double)statisticsList.get(0)).longValue(), ((Double)statisticsList.get(1)).longValue(), ((Double)statisticsList.get(2)).longValue(), ((Double)statisticsList.get(3)).longValue(), ((Double)statisticsList.get(4)).longValue(), ((Double)statisticsList.get(5)).longValue(), ((Double)statisticsList.get(6)).longValue(), ((Double)statisticsList.get(7)).longValue(), ((Double)statisticsList.get(8)).longValue(), ((Double)statisticsList.get(9)).longValue(), ((Double)statisticsList.get(10)).longValue(), ((Double)statisticsList.get(11)).longValue(), ((Double)statisticsList.get(12)).longValue(), ((Double)statisticsList.get(13)).longValue(), ((Double)statisticsList.get(14)).doubleValue(), ((Double)statisticsList.get(15)).doubleValue(), ((Double)statisticsList.get(16)).doubleValue());
    }

    static void getStatisticSummations(Client client, ActionListener<TransformIndexerStats> statsListener) {
        ConstantScoreQueryBuilder queryBuilder = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)TransformField.INDEX_DOC_TYPE.getPreferredName(), (String)"data_frame_transform_state_and_stats")));
        SearchRequestBuilder requestBuilder = client.prepareSearch(new String[]{".transform-internal-*", ".data-frame-internal-*"}).setSize(0).setQuery((QueryBuilder)queryBuilder);
        String path = TransformField.STATS_FIELD.getPreferredName() + ".";
        for (String statName : PROVIDED_STATS) {
            requestBuilder.addAggregation((AggregationBuilder)AggregationBuilders.sum((String)statName).field(path + statName));
        }
        ActionListener getStatisticSummationsListener = ActionListener.wrap(searchResponse -> {
            if (searchResponse.getShardFailures().length > 0) {
                logger.error("statistics summations search returned shard failures: {}", (Object)Arrays.toString(searchResponse.getShardFailures()));
            }
            statsListener.onResponse((Object)TransformInfoTransportAction.parseSearchAggs(searchResponse));
        }, failure -> {
            if (failure instanceof ResourceNotFoundException) {
                statsListener.onResponse((Object)new TransformIndexerStats());
            } else {
                statsListener.onFailure(failure);
            }
        });
        ClientHelper.executeAsyncWithOrigin((ThreadContext)client.threadPool().getThreadContext(), (String)"transform", (ActionRequest)((SearchRequest)requestBuilder.request()), (ActionListener)getStatisticSummationsListener, (arg_0, arg_1) -> ((Client)client).search(arg_0, arg_1));
    }
}

