/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.action;

import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.Instant;
import java.util.Base64;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.idp.action.PutSamlServiceProviderRequest;
import org.elasticsearch.xpack.idp.action.PutSamlServiceProviderResponse;
import org.elasticsearch.xpack.idp.saml.idp.SamlIdentityProvider;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProviderDocument;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProviderIndex;

public class TransportPutSamlServiceProviderAction
extends HandledTransportAction<PutSamlServiceProviderRequest, PutSamlServiceProviderResponse> {
    private static final Logger logger = LogManager.getLogger(TransportPutSamlServiceProviderAction.class);
    private final SamlServiceProviderIndex index;
    private final SamlIdentityProvider identityProvider;
    private final Clock clock;

    @Inject
    public TransportPutSamlServiceProviderAction(TransportService transportService, ActionFilters actionFilters, SamlServiceProviderIndex index, SamlIdentityProvider identityProvider) {
        this(transportService, actionFilters, index, identityProvider, Clock.systemUTC());
    }

    TransportPutSamlServiceProviderAction(TransportService transportService, ActionFilters actionFilters, SamlServiceProviderIndex index, SamlIdentityProvider identityProvider, Clock clock) {
        super("cluster:admin/idp/saml/sp/put", transportService, actionFilters, PutSamlServiceProviderRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.index = index;
        this.identityProvider = identityProvider;
        this.clock = clock;
    }

    protected void doExecute(Task task, PutSamlServiceProviderRequest request, ActionListener<PutSamlServiceProviderResponse> listener) {
        SamlServiceProviderDocument document = request.getDocument();
        if (document.docId != null) {
            listener.onFailure((Exception)new IllegalArgumentException("request document must not have an id [" + document.docId + "]"));
            return;
        }
        if (document.nameIdFormat != null && !this.identityProvider.getAllowedNameIdFormats().contains(document.nameIdFormat)) {
            listener.onFailure((Exception)new IllegalArgumentException("NameID format [" + document.nameIdFormat + "] is not supported."));
            return;
        }
        logger.trace("Searching for existing ServiceProvider with id [{}] for [{}]", (Object)document.entityId, (Object)request);
        this.index.findByEntityId(document.entityId, (ActionListener<Set<SamlServiceProviderIndex.DocumentSupplier>>)ActionListener.wrap(matchingDocuments -> {
            if (matchingDocuments.isEmpty()) {
                document.docId = TransportPutSamlServiceProviderAction.deriveDocumentId(document);
                logger.trace("No existing ServiceProvider for EntityID=[{}], writing new doc [{}]", (Object)document.entityId, (Object)document.docId);
                this.writeDocument(document, DocWriteRequest.OpType.CREATE, request.getRefreshPolicy(), listener);
            } else if (matchingDocuments.size() == 1) {
                SamlServiceProviderDocument existingDoc = ((SamlServiceProviderIndex.DocumentSupplier)Iterables.get((Iterable)matchingDocuments, (int)0)).getDocument();
                assert (existingDoc.docId != null) : "Loaded document with no doc id";
                assert (existingDoc.entityId.equals(document.entityId)) : "Loaded document with non-matching entity-id";
                document.setDocId(existingDoc.docId);
                document.setCreated(existingDoc.created);
                logger.trace("Found existing ServiceProvider for EntityID=[{}], writing to doc [{}]", (Object)document.entityId, (Object)document.docId);
                this.writeDocument(document, DocWriteRequest.OpType.INDEX, request.getRefreshPolicy(), listener);
            } else {
                logger.warn("Found multiple existing service providers in [{}] with entity id [{}] - [{}]", (Object)this.index, (Object)document.entityId, (Object)matchingDocuments.stream().map(d -> d.getDocument().docId).collect(Collectors.joining(",")));
                listener.onFailure((Exception)new IllegalStateException("Multiple service providers already exist with entity id [" + document.entityId + "]"));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void writeDocument(SamlServiceProviderDocument document, DocWriteRequest.OpType opType, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<PutSamlServiceProviderResponse> listener) {
        Instant now = this.clock.instant();
        if (document.created == null || opType == DocWriteRequest.OpType.CREATE) {
            document.created = now;
        }
        document.lastModified = now;
        ValidationException validationException = document.validate();
        if (validationException != null) {
            listener.onFailure((Exception)validationException);
            return;
        }
        logger.debug("[{}] service provider [{}] in document [{}] of [{}]", (Object)opType, (Object)document.entityId, (Object)document.docId, (Object)this.index);
        this.index.writeDocument(document, opType, refreshPolicy, (ActionListener<DocWriteResponse>)ActionListener.wrap(response -> listener.onResponse((Object)new PutSamlServiceProviderResponse(response.getId(), response.getResult() == DocWriteResponse.Result.CREATED, response.getSeqNo(), response.getPrimaryTerm(), document.entityId, document.enabled)), arg_0 -> listener.onFailure(arg_0)));
    }

    private static String deriveDocumentId(SamlServiceProviderDocument document) {
        byte[] sha256 = MessageDigests.sha256().digest(document.entityId.getBytes(StandardCharsets.UTF_8));
        return Base64.getUrlEncoder().withoutPadding().encodeToString(sha256);
    }
}

