/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.countedkeyword;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.fielddata.AbstractSortedSetDocValues;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractIndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractLeafOrdinalsFieldData;
import org.elasticsearch.index.mapper.BinaryFieldMapper;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.field.KeywordDocValuesField;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.XContentParser;

public class CountedKeywordFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "counted_keyword";
    public static final String COUNT_FIELD_NAME_SUFFIX = "_count";
    public static final FieldType FIELD_TYPE;
    public static FieldMapper.TypeParser PARSER;
    private final FieldType fieldType;
    private final BinaryFieldMapper countFieldMapper;

    protected CountedKeywordFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, BinaryFieldMapper countFieldMapper) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.fieldType = fieldType;
        this.countFieldMapper = countFieldMapper;
    }

    public boolean parsesArrayValue() {
        return true;
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        XContentParser parser = context.parser();
        TreeMap<String, Integer> values = new TreeMap<String, Integer>();
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return;
        }
        if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
            this.parseArray(context, values);
        } else if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            CountedKeywordFieldMapper.parseValue(parser, values);
        } else {
            throw new IllegalArgumentException("Encountered unexpected token [" + parser.currentToken() + "].");
        }
        int i = 0;
        int[] counts = new int[values.size()];
        for (Map.Entry value : values.entrySet()) {
            context.doc().add((IndexableField)new KeywordFieldMapper.KeywordField(this.name(), new BytesRef((CharSequence)value.getKey()), this.fieldType));
            counts[i++] = (Integer)value.getValue();
        }
        BytesStreamOutput streamOutput = new BytesStreamOutput();
        streamOutput.writeVIntArray(counts);
        context.doc().add((IndexableField)new BinaryDocValuesField(this.countFieldMapper.name(), streamOutput.bytes().toBytesRef()));
    }

    private void parseArray(DocumentParserContext context, SortedMap<String, Integer> values) throws IOException {
        XContentParser.Token token;
        XContentParser parser = context.parser();
        while (true) {
            if ((token = parser.nextToken()) == XContentParser.Token.END_ARRAY) {
                return;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                CountedKeywordFieldMapper.parseValue(parser, values);
                continue;
            }
            if (token != XContentParser.Token.VALUE_NULL) break;
        }
        throw new IllegalArgumentException("Encountered unexpected token [" + token + "].");
    }

    private static void parseValue(XContentParser parser, SortedMap<String, Integer> values) throws IOException {
        String value = parser.text();
        if (!values.containsKey(value)) {
            values.put(value, 1);
        } else {
            values.put(value, (Integer)values.get(value) + 1);
        }
    }

    public Iterator<Mapper> iterator() {
        ArrayList<Object> mappers = new ArrayList<Object>();
        Iterator m = super.iterator();
        while (m.hasNext()) {
            mappers.add((Mapper)m.next());
        }
        mappers.add(this.countFieldMapper);
        return mappers.iterator();
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    static {
        FieldType ft = new FieldType();
        ft.setDocValuesType(DocValuesType.SORTED_SET);
        ft.setTokenized(false);
        ft.setOmitNorms(true);
        ft.setIndexOptions(IndexOptions.DOCS);
        ft.freeze();
        FIELD_TYPE = CountedKeywordFieldMapper.freezeAndDeduplicateFieldType((FieldType)ft);
        PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n));
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        protected Builder(String name) {
            super(name);
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.meta};
        }

        public FieldMapper build(MapperBuilderContext context) {
            BinaryFieldMapper countFieldMapper = new BinaryFieldMapper.Builder(this.name + CountedKeywordFieldMapper.COUNT_FIELD_NAME_SUFFIX, true).build(context);
            return new CountedKeywordFieldMapper(this.name, FIELD_TYPE, (MappedFieldType)new CountedKeywordFieldType(context.buildFullName(this.name), true, false, true, new TextSearchInfo(FIELD_TYPE, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER), (Map)this.meta.getValue(), countFieldMapper.fieldType()), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo, countFieldMapper);
        }
    }

    static class CountedKeywordSortedBinaryDocValues
    extends AbstractSortedSetDocValues {
        private final SortedSetDocValues dvValues;
        private final BinaryDocValues dvCounts;
        private int sumCount;
        private Iterator<Long> ordsForThisDoc;
        private final ByteArrayStreamInput scratch = new ByteArrayStreamInput();

        CountedKeywordSortedBinaryDocValues(SortedSetDocValues dvValues, BinaryDocValues dvCounts) {
            this.dvValues = dvValues;
            this.dvCounts = dvCounts;
        }

        public boolean advanceExact(int doc) throws IOException {
            this.sumCount = 0;
            if (this.dvValues.advanceExact(doc)) {
                boolean exactMatch = this.dvCounts.advanceExact(doc);
                assert (exactMatch);
                BytesRef encodedValue = this.dvCounts.binaryValue();
                this.scratch.reset(encodedValue.bytes, encodedValue.offset, encodedValue.length);
                int[] counts = this.scratch.readVIntArray();
                assert (counts.length == this.dvValues.docValueCount());
                ArrayList<Long> values = new ArrayList<Long>();
                for (int count : counts) {
                    this.sumCount += count;
                    long ord = this.dvValues.nextOrd();
                    for (int j = 0; j < count; ++j) {
                        values.add(ord);
                    }
                }
                this.ordsForThisDoc = values.iterator();
                return true;
            }
            this.ordsForThisDoc = null;
            return false;
        }

        public int docValueCount() {
            return this.sumCount;
        }

        public long nextOrd() {
            if (this.ordsForThisDoc.hasNext()) {
                return this.ordsForThisDoc.next();
            }
            return -1L;
        }

        public BytesRef lookupOrd(long ord) throws IOException {
            return this.dvValues.lookupOrd(ord);
        }

        public long getValueCount() {
            return this.dvValues.getValueCount();
        }

        public TermsEnum termsEnum() throws IOException {
            return this.dvValues.termsEnum();
        }
    }

    private static class CountedKeywordFieldType
    extends StringFieldType {
        private final MappedFieldType countFieldType;

        CountedKeywordFieldType(String name, boolean isIndexed, boolean isStored, boolean hasDocValues, TextSearchInfo textSearchInfo, Map<String, String> meta, MappedFieldType countFieldType) {
            super(name, isIndexed, isStored, hasDocValues, textSearchInfo, meta);
            this.countFieldType = countFieldType;
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.identity((String)this.name(), (SearchExecutionContext)context, (String)format);
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return (cache, breakerService) -> new AbstractIndexOrdinalsFieldData(this.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, cache, breakerService, (dv, n) -> new KeywordDocValuesField(FieldData.toString((SortedSetDocValues)dv), n)){

                public LeafOrdinalsFieldData load(LeafReaderContext context) {
                    BinaryDocValues dvCounts;
                    SortedSetDocValues dvValues;
                    try {
                        dvValues = DocValues.getSortedSet((LeafReader)context.reader(), (String)this.getFieldName());
                        dvCounts = DocValues.getBinary((LeafReader)context.reader(), (String)countFieldType.name());
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Unable to load counted_keyword doc values", e);
                    }
                    return new AbstractLeafOrdinalsFieldData(this.toScriptFieldFactory){

                        public SortedSetDocValues getOrdinalsValues() {
                            return new CountedKeywordSortedBinaryDocValues(dvValues, dvCounts);
                        }

                        public long ramBytesUsed() {
                            return 0L;
                        }

                        public void close() {
                        }
                    };
                }

                public LeafOrdinalsFieldData loadDirect(LeafReaderContext context) {
                    return this.load(context);
                }

                public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
                    throw new UnsupportedOperationException("can't sort on the [counted_keyword] field");
                }

                public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
                    throw new IllegalArgumentException("can't sort on the [counted_keyword] field");
                }
            };
        }

        public String typeName() {
            return CountedKeywordFieldMapper.CONTENT_TYPE;
        }
    }
}

