/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.windows.service;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import joptsimple.OptionSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cli.Command;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;

abstract class ProcrunCommand
extends Command {
    private static final Logger logger = LogManager.getLogger(ProcrunCommand.class);
    private final String cmd;

    protected ProcrunCommand(String desc, String cmd) {
        super(desc);
        this.cmd = cmd;
    }

    protected String getExecutable() {
        return "elasticsearch-service-x64.exe";
    }

    protected void execute(Terminal terminal, OptionSet options, ProcessInfo processInfo) throws Exception {
        Path procrun = processInfo.workingDir().resolve("bin").resolve(this.getExecutable()).toAbsolutePath();
        if (!Files.exists(procrun, new LinkOption[0])) {
            throw new IllegalStateException("Missing procrun exe: " + procrun);
        }
        String serviceId = ProcrunCommand.getServiceId(options, processInfo.envVars());
        this.preExecute(terminal, processInfo, serviceId);
        ArrayList<String> procrunCmd = new ArrayList<String>();
        procrunCmd.add(ProcrunCommand.quote(procrun.toString()));
        procrunCmd.add("//%s/%s".formatted(this.cmd, serviceId));
        if (this.includeLogArgs()) {
            procrunCmd.add(ProcrunCommand.getLogArgs(serviceId, processInfo.workingDir(), processInfo.envVars()));
        }
        procrunCmd.add(this.getAdditionalArgs(serviceId, processInfo));
        ProcessBuilder processBuilder = new ProcessBuilder("cmd.exe", "/C", String.join((CharSequence)" ", procrunCmd).trim());
        logger.debug(() -> "Running procrun: " + String.join((CharSequence)" ", processBuilder.command()));
        processBuilder.inheritIO();
        Process process = this.startProcess(processBuilder);
        int ret = process.waitFor();
        if (ret != 0) {
            throw new UserException(ret, this.getFailureMessage(serviceId));
        }
        terminal.println((CharSequence)this.getSuccessMessage(serviceId));
    }

    static String quote(String s) {
        return "\"" + s + "\"";
    }

    private static String getServiceId(OptionSet options, Map<String, String> env) throws UserException {
        List args = options.nonOptionArguments();
        if (args.size() > 1) {
            throw new UserException(64, "too many arguments, expected one service id");
        }
        String serviceId = args.size() > 0 ? args.get(0).toString() : env.getOrDefault("SERVICE_ID", "elasticsearch-service-x64");
        return serviceId;
    }

    private static String getLogArgs(String serviceId, Path esHome, Map<String, String> env) {
        String logArgs = env.get("LOG_OPTS");
        if (logArgs != null && !logArgs.isBlank()) {
            return logArgs;
        }
        String logsDir = env.get("SERVICE_LOG_DIR");
        if (logsDir == null || logsDir.isBlank()) {
            logsDir = esHome.resolve("logs").toString();
        }
        String logArgsFormat = "--LogPath \"%s\" --LogPrefix \"%s\" --StdError auto --StdOutput auto --LogLevel Debug";
        return String.format(Locale.ROOT, logArgsFormat, logsDir, serviceId);
    }

    protected String getAdditionalArgs(String serviceId, ProcessInfo processInfo) {
        return "";
    }

    protected boolean includeLogArgs() {
        return true;
    }

    protected void preExecute(Terminal terminal, ProcessInfo pinfo, String serviceId) throws UserException {
    }

    protected abstract String getSuccessMessage(String var1);

    protected abstract String getFailureMessage(String var1);

    Process startProcess(ProcessBuilder processBuilder) throws IOException {
        return processBuilder.start();
    }
}

