/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.xpack.security.authc.ApiKeyService;

public class RemoteClusterCredentialsResolver {
    private static final Logger logger = LogManager.getLogger(RemoteClusterCredentialsResolver.class);
    private final Map<String, SecureString> clusterCredentials;

    public RemoteClusterCredentialsResolver(Settings settings) {
        this.clusterCredentials = RemoteClusterService.REMOTE_CLUSTER_CREDENTIALS.getAsMap(settings);
        logger.debug("Read cluster credentials for remote clusters [{}]", (Object)Strings.collectionToCommaDelimitedString(this.clusterCredentials.keySet()));
    }

    public Optional<RemoteClusterCredentials> resolve(String clusterAlias) {
        SecureString apiKey = this.clusterCredentials.get(clusterAlias);
        if (apiKey == null) {
            return Optional.empty();
        }
        return Optional.of(new RemoteClusterCredentials(clusterAlias, ApiKeyService.withApiKeyPrefix(apiKey.toString())));
    }

    record RemoteClusterCredentials(String clusterAlias, String credentials) {
        @Override
        public String toString() {
            return "RemoteClusterCredentials{clusterAlias='" + this.clusterAlias + "', credentials='::es_redacted::'}";
        }
    }
}

