/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.apikey;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.Grant;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyRequestBuilder;
import org.elasticsearch.xpack.core.security.action.apikey.GrantApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.GrantApiKeyRequest;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.rest.action.apikey.ApiKeyBaseRestHandler;

@ServerlessScope(value=Scope.INTERNAL)
public final class RestGrantApiKeyAction
extends ApiKeyBaseRestHandler
implements RestRequestFilter {
    private static final ConstructingObjectParser<Grant.ClientAuthentication, Void> CLIENT_AUTHENTICATION_PARSER = new ConstructingObjectParser("client_authentication", a -> new Grant.ClientAuthentication((String)a[0], (SecureString)a[1]));
    static final ObjectParser<GrantApiKeyRequest, Void> PARSER;
    private static final Set<String> FILTERED_FIELDS;

    private static SecureString getSecureString(XContentParser parser) throws IOException {
        return new SecureString(Arrays.copyOfRange(parser.textCharacters(), parser.textOffset(), parser.textOffset() + parser.textLength()));
    }

    public RestGrantApiKeyAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_security/api_key/grant"), new RestHandler.Route(RestRequest.Method.PUT, "/_security/api_key/grant"));
    }

    public String getName() {
        return "xpack_security_grant_api_key";
    }

    public static GrantApiKeyRequest fromXContent(XContentParser parser) throws IOException {
        return (GrantApiKeyRequest)PARSER.parse(parser, null);
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String refresh = request.param("refresh");
        try (XContentParser parser = request.contentParser();){
            GrantApiKeyRequest grantRequest = RestGrantApiKeyAction.fromXContent(parser);
            if (refresh != null) {
                grantRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.parse((String)refresh));
            } else {
                grantRequest.setRefreshPolicy(ApiKeyService.defaultCreateDocRefreshPolicy(this.settings));
            }
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)GrantApiKeyAction.INSTANCE, (ActionRequest)grantRequest, new RestToXContentListener(channel).delegateResponse((listener, ex) -> {
                RestStatus status = ExceptionsHelper.status((Throwable)ex);
                if (status == RestStatus.UNAUTHORIZED) {
                    listener.onFailure((Exception)new ElasticsearchSecurityException("Failed to authenticate api key grant", RestStatus.FORBIDDEN, (Throwable)ex, new Object[0]));
                } else {
                    listener.onFailure(ex);
                }
            }));
            return restChannelConsumer;
        }
    }

    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }

    static {
        CLIENT_AUTHENTICATION_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("scheme", new String[0]));
        CLIENT_AUTHENTICATION_PARSER.declareField(ConstructingObjectParser.constructorArg(), RestGrantApiKeyAction::getSecureString, new ParseField("value", new String[0]), ObjectParser.ValueType.STRING);
        PARSER = new ObjectParser("grant_api_key_request", GrantApiKeyRequest::new);
        PARSER.declareString((req, str) -> req.getGrant().setType(str), new ParseField("grant_type", new String[0]));
        PARSER.declareString((req, str) -> req.getGrant().setUsername(str), new ParseField("username", new String[0]));
        PARSER.declareField((req, secStr) -> req.getGrant().setPassword(secStr), RestGrantApiKeyAction::getSecureString, new ParseField("password", new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareField((req, secStr) -> req.getGrant().setAccessToken(secStr), RestGrantApiKeyAction::getSecureString, new ParseField("access_token", new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareString((req, str) -> req.getGrant().setRunAsUsername(str), new ParseField("run_as", new String[0]));
        PARSER.declareObject((req, clientAuthentication) -> req.getGrant().setClientAuthentication(clientAuthentication), CLIENT_AUTHENTICATION_PARSER, new ParseField("client_authentication", new String[0]));
        PARSER.declareObject((req, api) -> req.setApiKeyRequest(api), (parser, ignore) -> CreateApiKeyRequestBuilder.parse((XContentParser)parser), new ParseField("api_key", new String[0]));
        FILTERED_FIELDS = Set.of("password", "access_token", "client_authentication.value");
    }
}

