/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.core.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.security.authc.support.DnRoleMapper;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;

public class CompositeRoleMapper
implements UserRoleMapper {
    private List<UserRoleMapper> delegates;

    public CompositeRoleMapper(RealmConfig realmConfig, ResourceWatcherService watcherService, NativeRoleMappingStore nativeRoleMappingStore) {
        this(new DnRoleMapper(realmConfig, watcherService), nativeRoleMappingStore);
    }

    private CompositeRoleMapper(UserRoleMapper ... delegates) {
        this.delegates = new ArrayList<UserRoleMapper>(Arrays.asList(delegates));
    }

    public void resolveRoles(UserRoleMapper.UserData user, ActionListener<Set<String>> listener) {
        GroupedActionListener groupListener = new GroupedActionListener(this.delegates.size(), ActionListener.wrap(composite -> listener.onResponse(composite.stream().flatMap(Collection::stream).collect(Collectors.toSet())), arg_0 -> listener.onFailure(arg_0)));
        this.delegates.forEach(mapper -> mapper.resolveRoles(user, (ActionListener)groupListener));
    }

    public void refreshRealmOnChange(CachingRealm realm) {
        this.delegates.forEach(mapper -> mapper.refreshRealmOnChange(realm));
    }
}

