/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.rolemapping;

import java.util.Optional;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ReservedStateAwareHandledTransportAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.rolemapping.PutRoleMappingRequest;
import org.elasticsearch.xpack.core.security.action.rolemapping.PutRoleMappingResponse;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;

public class TransportPutRoleMappingAction
extends ReservedStateAwareHandledTransportAction<PutRoleMappingRequest, PutRoleMappingResponse> {
    private final NativeRoleMappingStore roleMappingStore;

    @Inject
    public TransportPutRoleMappingAction(ActionFilters actionFilters, TransportService transportService, ClusterService clusterService, NativeRoleMappingStore roleMappingStore) {
        super("cluster:admin/xpack/security/role_mapping/put", clusterService, transportService, actionFilters, PutRoleMappingRequest::new);
        this.roleMappingStore = roleMappingStore;
    }

    protected void doExecuteProtected(Task task, PutRoleMappingRequest request, ActionListener<PutRoleMappingResponse> listener) {
        this.roleMappingStore.putRoleMapping(request, (ActionListener<Boolean>)ActionListener.wrap(created -> listener.onResponse((Object)new PutRoleMappingResponse(created.booleanValue())), arg_0 -> listener.onFailure(arg_0)));
    }

    public Optional<String> reservedStateHandlerName() {
        return Optional.of("role_mappings");
    }

    public Set<String> modifiedKeys(PutRoleMappingRequest request) {
        return Set.of(request.getName());
    }
}

