/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.apikey;

import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.apikey.QueryApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.QueryApiKeyResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.support.ApiKeyBoolQueryBuilder;
import org.elasticsearch.xpack.security.support.ApiKeyFieldNameTranslators;

public final class TransportQueryApiKeyAction
extends HandledTransportAction<QueryApiKeyRequest, QueryApiKeyResponse> {
    private final ApiKeyService apiKeyService;
    private final SecurityContext securityContext;

    @Inject
    public TransportQueryApiKeyAction(TransportService transportService, ActionFilters actionFilters, ApiKeyService apiKeyService, SecurityContext context) {
        super("cluster:admin/xpack/security/api_key/query", transportService, actionFilters, QueryApiKeyRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.apiKeyService = apiKeyService;
        this.securityContext = context;
    }

    protected void doExecute(Task task, QueryApiKeyRequest request, ActionListener<QueryApiKeyResponse> listener) {
        Authentication authentication = this.securityContext.getAuthentication();
        if (authentication == null) {
            listener.onFailure((Exception)new IllegalStateException("authentication is required"));
        }
        SearchSourceBuilder searchSourceBuilder = SearchSourceBuilder.searchSource().version(Boolean.valueOf(false)).fetchSource(true).trackTotalHits(true);
        if (request.getFrom() != null) {
            searchSourceBuilder.from(request.getFrom().intValue());
        }
        if (request.getSize() != null) {
            searchSourceBuilder.size(request.getSize().intValue());
        }
        ApiKeyBoolQueryBuilder apiKeyBoolQueryBuilder = ApiKeyBoolQueryBuilder.build(request.getQueryBuilder(), (Authentication)(request.isFilterForCurrentUser() ? authentication : null));
        searchSourceBuilder.query((QueryBuilder)apiKeyBoolQueryBuilder);
        if (request.getFieldSortBuilders() != null) {
            TransportQueryApiKeyAction.translateFieldSortBuilders(request.getFieldSortBuilders(), searchSourceBuilder);
        }
        if (request.getSearchAfterBuilder() != null) {
            searchSourceBuilder.searchAfter(request.getSearchAfterBuilder().getSortValues());
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{".security"}, searchSourceBuilder);
        this.apiKeyService.queryApiKeys(searchRequest, request.withLimitedBy(), listener);
    }

    static void translateFieldSortBuilders(List<FieldSortBuilder> fieldSortBuilders, SearchSourceBuilder searchSourceBuilder) {
        fieldSortBuilders.forEach(fieldSortBuilder -> {
            if (fieldSortBuilder.getNestedSort() != null) {
                throw new IllegalArgumentException("nested sorting is not supported for API Key query");
            }
            if ("_doc".equals(fieldSortBuilder.getFieldName())) {
                searchSourceBuilder.sort((SortBuilder)fieldSortBuilder);
            } else {
                String translatedFieldName = ApiKeyFieldNameTranslators.translate(fieldSortBuilder.getFieldName());
                if (translatedFieldName.equals(fieldSortBuilder.getFieldName())) {
                    searchSourceBuilder.sort((SortBuilder)fieldSortBuilder);
                } else {
                    FieldSortBuilder translatedFieldSortBuilder = ((FieldSortBuilder)new FieldSortBuilder(translatedFieldName).order(fieldSortBuilder.order())).missing(fieldSortBuilder.missing()).unmappedType(fieldSortBuilder.unmappedType()).setFormat(fieldSortBuilder.getFormat());
                    if (fieldSortBuilder.sortMode() != null) {
                        translatedFieldSortBuilder.sortMode(fieldSortBuilder.sortMode());
                    }
                    if (fieldSortBuilder.getNestedSort() != null) {
                        translatedFieldSortBuilder.setNestedSort(fieldSortBuilder.getNestedSort());
                    }
                    if (fieldSortBuilder.getNumericType() != null) {
                        translatedFieldSortBuilder.setNumericType(fieldSortBuilder.getNumericType());
                    }
                    searchSourceBuilder.sort((SortBuilder)translatedFieldSortBuilder);
                }
            }
        });
    }
}

