/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.apikey;

import java.util.Set;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.apikey.AbstractCreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.support.ApiKeyUserRoleDescriptorResolver;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public final class TransportCreateApiKeyAction
extends HandledTransportAction<CreateApiKeyRequest, CreateApiKeyResponse> {
    private final ApiKeyService apiKeyService;
    private final ApiKeyUserRoleDescriptorResolver resolver;
    private final SecurityContext securityContext;

    @Inject
    public TransportCreateApiKeyAction(TransportService transportService, ActionFilters actionFilters, ApiKeyService apiKeyService, SecurityContext context, CompositeRolesStore rolesStore, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/xpack/security/api_key/create", transportService, actionFilters, CreateApiKeyRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.apiKeyService = apiKeyService;
        this.resolver = new ApiKeyUserRoleDescriptorResolver(rolesStore, xContentRegistry);
        this.securityContext = context;
    }

    protected void doExecute(Task task, CreateApiKeyRequest request, ActionListener<CreateApiKeyResponse> listener) {
        Authentication authentication = this.securityContext.getAuthentication();
        if (authentication == null) {
            listener.onFailure((Exception)new IllegalStateException("authentication is required"));
        } else {
            if (authentication.isApiKey() && TransportCreateApiKeyAction.grantsAnyPrivileges(request)) {
                listener.onFailure((Exception)new IllegalArgumentException("creating derived api keys requires an explicit role descriptor that is empty (has no privileges)"));
                return;
            }
            this.resolver.resolveUserRoleDescriptors(authentication, (ActionListener<Set<RoleDescriptor>>)ActionListener.wrap(roleDescriptors -> this.apiKeyService.createApiKey(authentication, (AbstractCreateApiKeyRequest)request, (Set<RoleDescriptor>)roleDescriptors, listener), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private static boolean grantsAnyPrivileges(CreateApiKeyRequest request) {
        return request.getRoleDescriptors() == null || request.getRoleDescriptors().isEmpty() || false == request.getRoleDescriptors().stream().allMatch(RoleDescriptor::isEmpty);
    }
}

