/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.execution;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;

public class Wid {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME;
    private final String watchId;
    private final String value;

    public Wid(String watchId, ZonedDateTime executionTime) {
        this.watchId = watchId;
        this.value = watchId + "_" + UUID.randomUUID().toString() + "-" + formatter.format(executionTime);
    }

    public Wid(String value) {
        this.value = value;
        int index = value.lastIndexOf("_");
        if (index <= 0) {
            throw Exceptions.illegalArgument("invalid watcher execution id [{}]", value);
        }
        this.watchId = value.substring(0, index);
    }

    public String value() {
        return this.value;
    }

    public String watchId() {
        return this.watchId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Wid wid = (Wid)o;
        return this.value.equals(wid.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }
}

