/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.slm;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SnapshotLifecycleStats
implements Writeable,
ToXContentObject {
    private final CounterMetric retentionRunCount = new CounterMetric();
    private final CounterMetric retentionFailedCount = new CounterMetric();
    private final CounterMetric retentionTimedOut = new CounterMetric();
    private final CounterMetric retentionTimeMs = new CounterMetric();
    private final Map<String, SnapshotPolicyStats> policyStats;
    public static final ParseField RETENTION_RUNS = new ParseField("retention_runs", new String[0]);
    public static final ParseField RETENTION_FAILED = new ParseField("retention_failed", new String[0]);
    public static final ParseField RETENTION_TIMED_OUT = new ParseField("retention_timed_out", new String[0]);
    public static final ParseField RETENTION_TIME = new ParseField("retention_deletion_time", new String[0]);
    public static final ParseField RETENTION_TIME_MILLIS = new ParseField("retention_deletion_time_millis", new String[0]);
    public static final ParseField POLICY_STATS = new ParseField("policy_stats", new String[0]);
    public static final ParseField TOTAL_TAKEN = new ParseField("total_snapshots_taken", new String[0]);
    public static final ParseField TOTAL_FAILED = new ParseField("total_snapshots_failed", new String[0]);
    public static final ParseField TOTAL_DELETIONS = new ParseField("total_snapshots_deleted", new String[0]);
    public static final ParseField TOTAL_DELETION_FAILURES = new ParseField("total_snapshot_deletion_failures", new String[0]);
    private static final ConstructingObjectParser<SnapshotLifecycleStats, Void> PARSER = new ConstructingObjectParser("snapshot_policy_stats", true, a -> {
        long runs = (Long)a[0];
        long failed = (Long)a[1];
        long timedOut = (Long)a[2];
        long timeMs = (Long)a[3];
        Map<String, SnapshotPolicyStats> policyStatsMap = ((List)a[4]).stream().collect(Collectors.toMap(m -> m.policyId, Function.identity()));
        return new SnapshotLifecycleStats(runs, failed, timedOut, timeMs, policyStatsMap);
    });

    public SnapshotLifecycleStats() {
        this.policyStats = new ConcurrentHashMap<String, SnapshotPolicyStats>();
    }

    public SnapshotLifecycleStats(long retentionRuns, long retentionFailed, long retentionTimedOut, long retentionTimeMs, Map<String, SnapshotPolicyStats> policyStats) {
        this.retentionRunCount.inc(retentionRuns);
        this.retentionFailedCount.inc(retentionFailed);
        this.retentionTimedOut.inc(retentionTimedOut);
        this.retentionTimeMs.inc(retentionTimeMs);
        this.policyStats = policyStats;
    }

    public SnapshotLifecycleStats(StreamInput in) throws IOException {
        this.policyStats = new ConcurrentHashMap<String, SnapshotPolicyStats>(in.readMap(SnapshotPolicyStats::new));
        this.retentionRunCount.inc(in.readVLong());
        this.retentionFailedCount.inc(in.readVLong());
        this.retentionTimedOut.inc(in.readVLong());
        this.retentionTimeMs.inc(in.readVLong());
    }

    public static SnapshotLifecycleStats parse(XContentParser parser) {
        return (SnapshotLifecycleStats)PARSER.apply(parser, null);
    }

    public SnapshotLifecycleStats merge(SnapshotLifecycleStats other) {
        HashMap<String, SnapshotPolicyStats> newPolicyStats = new HashMap<String, SnapshotPolicyStats>(this.policyStats);
        other.policyStats.forEach((policyId, perRunPolicyStats) -> newPolicyStats.compute((String)policyId, (k, existingPolicyMetrics) -> {
            if (existingPolicyMetrics == null) {
                return perRunPolicyStats;
            }
            return existingPolicyMetrics.merge((SnapshotPolicyStats)perRunPolicyStats);
        }));
        return new SnapshotLifecycleStats(this.retentionRunCount.count() + other.retentionRunCount.count(), this.retentionFailedCount.count() + other.retentionFailedCount.count(), this.retentionTimedOut.count() + other.retentionTimedOut.count(), this.retentionTimeMs.count() + other.retentionTimeMs.count(), newPolicyStats);
    }

    public SnapshotLifecycleStats removePolicy(String policyId) {
        HashMap<String, SnapshotPolicyStats> policyStatsCopy = new HashMap<String, SnapshotPolicyStats>(this.policyStats);
        policyStatsCopy.remove(policyId);
        return new SnapshotLifecycleStats(this.retentionRunCount.count(), this.retentionFailedCount.count(), this.retentionTimedOut.count(), this.retentionTimeMs.count(), policyStatsCopy);
    }

    public Map<String, SnapshotPolicyStats> getMetrics() {
        return Collections.unmodifiableMap(this.policyStats);
    }

    public void retentionRun() {
        this.retentionRunCount.inc();
    }

    public void retentionFailed() {
        this.retentionFailedCount.inc();
    }

    public void retentionTimedOut() {
        this.retentionTimedOut.inc();
    }

    public void deletionTime(TimeValue elapsedTime) {
        this.retentionTimeMs.inc(elapsedTime.millis());
    }

    public void snapshotTaken(String slmPolicy) {
        this.policyStats.computeIfAbsent(slmPolicy, SnapshotPolicyStats::new).snapshotTaken();
    }

    public void snapshotFailed(String slmPolicy) {
        this.policyStats.computeIfAbsent(slmPolicy, SnapshotPolicyStats::new).snapshotFailed();
    }

    public void snapshotDeleted(String slmPolicy) {
        this.policyStats.computeIfAbsent(slmPolicy, SnapshotPolicyStats::new).snapshotDeleted();
    }

    public void snapshotDeleteFailure(String slmPolicy) {
        this.policyStats.computeIfAbsent(slmPolicy, SnapshotPolicyStats::new).snapshotDeleteFailure();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.policyStats, StreamOutput::writeWriteable);
        out.writeVLong(this.retentionRunCount.count());
        out.writeVLong(this.retentionFailedCount.count());
        out.writeVLong(this.retentionTimedOut.count());
        out.writeVLong(this.retentionTimeMs.count());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(RETENTION_RUNS.getPreferredName(), this.retentionRunCount.count());
        builder.field(RETENTION_FAILED.getPreferredName(), this.retentionFailedCount.count());
        builder.field(RETENTION_TIMED_OUT.getPreferredName(), this.retentionTimedOut.count());
        TimeValue retentionTime = TimeValue.timeValueMillis((long)this.retentionTimeMs.count());
        builder.field(RETENTION_TIME.getPreferredName(), (Object)retentionTime);
        builder.field(RETENTION_TIME_MILLIS.getPreferredName(), retentionTime.millis());
        List<SnapshotPolicyStats> metrics = this.getMetrics().values().stream().sorted(Comparator.comparing(SnapshotPolicyStats::getPolicyId)).toList();
        long totalTaken = metrics.stream().mapToLong(s -> s.snapshotsTaken.count()).sum();
        long totalFailed = metrics.stream().mapToLong(s -> s.snapshotsFailed.count()).sum();
        long totalDeleted = metrics.stream().mapToLong(s -> s.snapshotsDeleted.count()).sum();
        long totalDeleteFailures = metrics.stream().mapToLong(s -> s.snapshotDeleteFailures.count()).sum();
        builder.field(TOTAL_TAKEN.getPreferredName(), totalTaken);
        builder.field(TOTAL_FAILED.getPreferredName(), totalFailed);
        builder.field(TOTAL_DELETIONS.getPreferredName(), totalDeleted);
        builder.field(TOTAL_DELETION_FAILURES.getPreferredName(), totalDeleteFailures);
        builder.startArray(POLICY_STATS.getPreferredName());
        for (SnapshotPolicyStats stats : metrics) {
            builder.startObject();
            stats.toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.retentionRunCount.count(), this.retentionFailedCount.count(), this.retentionTimedOut.count(), this.retentionTimeMs.count(), this.policyStats);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SnapshotLifecycleStats other = (SnapshotLifecycleStats)obj;
        return Objects.equals(this.retentionRunCount.count(), other.retentionRunCount.count()) && Objects.equals(this.retentionFailedCount.count(), other.retentionFailedCount.count()) && Objects.equals(this.retentionTimedOut.count(), other.retentionTimedOut.count()) && Objects.equals(this.retentionTimeMs.count(), other.retentionTimeMs.count()) && Objects.equals(this.policyStats, other.policyStats);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), RETENTION_RUNS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), RETENTION_FAILED);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), RETENTION_TIMED_OUT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), RETENTION_TIME_MILLIS);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), SnapshotPolicyStats.PARSER, POLICY_STATS);
    }

    public static class SnapshotPolicyStats
    implements Writeable,
    ToXContentFragment {
        private final String policyId;
        private final CounterMetric snapshotsTaken = new CounterMetric();
        private final CounterMetric snapshotsFailed = new CounterMetric();
        private final CounterMetric snapshotsDeleted = new CounterMetric();
        private final CounterMetric snapshotDeleteFailures = new CounterMetric();
        public static final ParseField POLICY_ID = new ParseField("policy", new String[0]);
        public static final ParseField SNAPSHOTS_TAKEN = new ParseField("snapshots_taken", new String[0]);
        public static final ParseField SNAPSHOTS_FAILED = new ParseField("snapshots_failed", new String[0]);
        public static final ParseField SNAPSHOTS_DELETED = new ParseField("snapshots_deleted", new String[0]);
        public static final ParseField SNAPSHOT_DELETION_FAILURES = new ParseField("snapshot_deletion_failures", new String[0]);
        static final ConstructingObjectParser<SnapshotPolicyStats, Void> PARSER = new ConstructingObjectParser("snapshot_policy_stats", true, a -> {
            String id = (String)a[0];
            long taken = (Long)a[1];
            long failed = (Long)a[2];
            long deleted = (Long)a[3];
            long deleteFailed = (Long)a[4];
            return new SnapshotPolicyStats(id, taken, failed, deleted, deleteFailed);
        });

        public SnapshotPolicyStats(String slmPolicy) {
            this.policyId = slmPolicy;
        }

        public SnapshotPolicyStats(String policyId, long snapshotsTaken, long snapshotsFailed, long deleted, long failedDeletes) {
            this.policyId = policyId;
            this.snapshotsTaken.inc(snapshotsTaken);
            this.snapshotsFailed.inc(snapshotsFailed);
            this.snapshotsDeleted.inc(deleted);
            this.snapshotDeleteFailures.inc(failedDeletes);
        }

        public SnapshotPolicyStats(StreamInput in) throws IOException {
            this.policyId = in.readString();
            this.snapshotsTaken.inc(in.readVLong());
            this.snapshotsFailed.inc(in.readVLong());
            this.snapshotsDeleted.inc(in.readVLong());
            this.snapshotDeleteFailures.inc(in.readVLong());
        }

        public static SnapshotPolicyStats parse(XContentParser parser) {
            return (SnapshotPolicyStats)PARSER.apply(parser, null);
        }

        public SnapshotPolicyStats merge(SnapshotPolicyStats other) {
            return new SnapshotPolicyStats(this.policyId, this.snapshotsTaken.count() + other.snapshotsTaken.count(), this.snapshotsFailed.count() + other.snapshotsFailed.count(), this.snapshotsDeleted.count() + other.snapshotsDeleted.count(), this.snapshotDeleteFailures.count() + other.snapshotDeleteFailures.count());
        }

        void snapshotTaken() {
            this.snapshotsTaken.inc();
        }

        void snapshotFailed() {
            this.snapshotsFailed.inc();
        }

        void snapshotDeleted() {
            this.snapshotsDeleted.inc();
        }

        void snapshotDeleteFailure() {
            this.snapshotDeleteFailures.inc();
        }

        public String getPolicyId() {
            return this.policyId;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.policyId);
            out.writeVLong(this.snapshotsTaken.count());
            out.writeVLong(this.snapshotsFailed.count());
            out.writeVLong(this.snapshotsDeleted.count());
            out.writeVLong(this.snapshotDeleteFailures.count());
        }

        public int hashCode() {
            return Objects.hash(this.policyId, this.snapshotsTaken.count(), this.snapshotsFailed.count(), this.snapshotsDeleted.count(), this.snapshotDeleteFailures.count());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            SnapshotPolicyStats other = (SnapshotPolicyStats)obj;
            return Objects.equals(this.policyId, other.policyId) && Objects.equals(this.snapshotsTaken.count(), other.snapshotsTaken.count()) && Objects.equals(this.snapshotsFailed.count(), other.snapshotsFailed.count()) && Objects.equals(this.snapshotsDeleted.count(), other.snapshotsDeleted.count()) && Objects.equals(this.snapshotDeleteFailures.count(), other.snapshotDeleteFailures.count());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(POLICY_ID.getPreferredName(), this.policyId);
            builder.field(SNAPSHOTS_TAKEN.getPreferredName(), this.snapshotsTaken.count());
            builder.field(SNAPSHOTS_FAILED.getPreferredName(), this.snapshotsFailed.count());
            builder.field(SNAPSHOTS_DELETED.getPreferredName(), this.snapshotsDeleted.count());
            builder.field(SNAPSHOT_DELETION_FAILURES.getPreferredName(), this.snapshotDeleteFailures.count());
            return builder;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), POLICY_ID);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SNAPSHOTS_TAKEN);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SNAPSHOTS_FAILED);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SNAPSHOTS_DELETED);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SNAPSHOT_DELETION_FAILURES);
        }
    }
}

