/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.slm;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SnapshotInvocationRecord
implements SimpleDiffable<SnapshotInvocationRecord>,
Writeable,
ToXContentObject {
    static final ParseField SNAPSHOT_NAME = new ParseField("snapshot_name", new String[0]);
    static final ParseField START_TIMESTAMP = new ParseField("start_time", new String[0]);
    static final ParseField TIMESTAMP = new ParseField("time", new String[0]);
    static final ParseField DETAILS = new ParseField("details", new String[0]);
    static final int MAX_DETAILS_LENGTH = 1000;
    private final String snapshotName;
    private final Long snapshotStartTimestamp;
    private final long snapshotFinishTimestamp;
    private final String details;
    public static final ConstructingObjectParser<SnapshotInvocationRecord, String> PARSER = new ConstructingObjectParser("snapshot_policy_invocation_record", true, a -> new SnapshotInvocationRecord((String)a[0], (Long)a[1], (Long)a[2], (String)a[3]));

    public static SnapshotInvocationRecord parse(XContentParser parser, String name) {
        return (SnapshotInvocationRecord)PARSER.apply(parser, (Object)name);
    }

    public SnapshotInvocationRecord(String snapshotName, Long snapshotStartTimestamp, long snapshotFinishTimestamp, @Nullable String details) {
        this.snapshotName = Objects.requireNonNull(snapshotName, "snapshot name must be provided");
        this.snapshotStartTimestamp = snapshotStartTimestamp;
        this.snapshotFinishTimestamp = snapshotFinishTimestamp;
        this.details = Strings.substring((String)details, (int)0, (int)1000);
    }

    public SnapshotInvocationRecord(StreamInput in) throws IOException {
        this.snapshotName = in.readString();
        this.snapshotStartTimestamp = in.readOptionalVLong();
        this.snapshotFinishTimestamp = in.readVLong();
        this.details = in.readOptionalString();
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    @Nullable
    public Long getSnapshotStartTimestamp() {
        return this.snapshotStartTimestamp;
    }

    public long getSnapshotFinishTimestamp() {
        return this.snapshotFinishTimestamp;
    }

    public String getDetails() {
        return this.details;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.snapshotName);
        out.writeOptionalVLong(this.snapshotStartTimestamp);
        out.writeVLong(this.snapshotFinishTimestamp);
        out.writeOptionalString(this.details);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SNAPSHOT_NAME.getPreferredName(), this.snapshotName);
        if (this.snapshotStartTimestamp != null) {
            builder.timeField(START_TIMESTAMP.getPreferredName(), "start_time_string", this.snapshotStartTimestamp.longValue());
        }
        builder.timeField(TIMESTAMP.getPreferredName(), "time_string", this.snapshotFinishTimestamp);
        if (Objects.nonNull(this.details)) {
            builder.field(DETAILS.getPreferredName(), this.details);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotInvocationRecord that = (SnapshotInvocationRecord)o;
        return this.getSnapshotFinishTimestamp() == that.getSnapshotFinishTimestamp() && Objects.equals(this.getSnapshotStartTimestamp(), that.getSnapshotStartTimestamp()) && Objects.equals(this.getSnapshotName(), that.getSnapshotName()) && Objects.equals(this.getDetails(), that.getDetails());
    }

    public int hashCode() {
        return Objects.hash(this.getSnapshotName(), this.getSnapshotStartTimestamp(), this.getSnapshotFinishTimestamp(), this.getDetails());
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SNAPSHOT_NAME);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), START_TIMESTAMP);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), TIMESTAMP);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), DETAILS);
    }
}

