/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.oidc;

import java.io.IOException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.Authentication;

public class OpenIdConnectAuthenticateResponse
extends ActionResponse {
    private String principal;
    private String accessTokenString;
    private String refreshTokenString;
    private TimeValue expiresIn;
    private Authentication authentication;

    public OpenIdConnectAuthenticateResponse(Authentication authentication, String accessTokenString, String refreshTokenString, TimeValue expiresIn) {
        this.principal = authentication.getEffectiveSubject().getUser().principal();
        this.accessTokenString = accessTokenString;
        this.refreshTokenString = refreshTokenString;
        this.expiresIn = expiresIn;
        this.authentication = authentication;
    }

    public OpenIdConnectAuthenticateResponse(StreamInput in) throws IOException {
        super(in);
        this.principal = in.readString();
        this.accessTokenString = in.readString();
        this.refreshTokenString = in.readString();
        this.expiresIn = in.readTimeValue();
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_11_0)) {
            this.authentication = new Authentication(in);
        }
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getAccessTokenString() {
        return this.accessTokenString;
    }

    public String getRefreshTokenString() {
        return this.refreshTokenString;
    }

    public TimeValue getExpiresIn() {
        return this.expiresIn;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.principal);
        out.writeString(this.accessTokenString);
        out.writeString(this.refreshTokenString);
        out.writeTimeValue(this.expiresIn);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_11_0)) {
            this.authentication.writeTo(out);
        }
    }
}

