/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.node.info.TransportNodesInfoAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.core.Strings;
import org.elasticsearch.monitor.os.OsInfo;
import org.elasticsearch.plugins.Platforms;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;

public class MlPlatformArchitecturesUtil {
    public static void getMlNodesArchitecturesSet(ActionListener<Set<String>> architecturesListener, Client client, ExecutorService executor) {
        ActionListener<NodesInfoResponse> listener = MlPlatformArchitecturesUtil.getArchitecturesSetFromNodesInfoResponseListener(executor, architecturesListener);
        NodesInfoRequest request = (NodesInfoRequest)MlPlatformArchitecturesUtil.getNodesInfoBuilderWithMlNodeArchitectureInfo(client).request();
        ClientHelper.executeAsyncWithOrigin(client, "ml", TransportNodesInfoAction.TYPE, request, listener);
    }

    static ActionListener<NodesInfoResponse> getArchitecturesSetFromNodesInfoResponseListener(ExecutorService executor, ActionListener<Set<String>> architecturesListener) {
        return architecturesListener.delegateFailureAndWrap((l, nodesInfoResponse) -> executor.execute(() -> l.onResponse(MlPlatformArchitecturesUtil.getArchitecturesSetFromNodesInfoResponse(nodesInfoResponse))));
    }

    static NodesInfoRequestBuilder getNodesInfoBuilderWithMlNodeArchitectureInfo(Client client) {
        return ((NodesInfoRequestBuilder)client.admin().cluster().prepareNodesInfo(new String[0]).clear().setNodesIds(new String[]{"ml:true"})).setOs(true).setPlugins(true);
    }

    private static Set<String> getArchitecturesSetFromNodesInfoResponse(NodesInfoResponse nodesInfoResponse) {
        return nodesInfoResponse.getNodes().stream().filter(node -> node.getNode().hasRole(DiscoveryNodeRole.ML_ROLE.roleName())).map(node -> {
            OsInfo osInfo = (OsInfo)node.getInfo(OsInfo.class);
            return Platforms.platformName((String)osInfo.getName(), (String)osInfo.getArch());
        }).collect(Collectors.toUnmodifiableSet());
    }

    public static void verifyMlNodesAndModelArchitectures(ActionListener<TrainedModelConfig> successOrFailureListener, Client client, ExecutorService executor, TrainedModelConfig configToReturn) {
        String modelID = configToReturn.getModelId();
        String modelPlatformArchitecture = configToReturn.getPlatformArchitecture();
        ActionListener architecturesListener = successOrFailureListener.delegateFailureAndWrap((l, architectures) -> {
            MlPlatformArchitecturesUtil.verifyMlNodesAndModelArchitectures(architectures, modelPlatformArchitecture, modelID);
            l.onResponse((Object)configToReturn);
        });
        MlPlatformArchitecturesUtil.getMlNodesArchitecturesSet((ActionListener<Set<String>>)architecturesListener, client, executor);
    }

    static void verifyMlNodesAndModelArchitectures(Set<String> architectures, String modelPlatformArchitecture, String modelID) throws IllegalArgumentException, IllegalStateException {
        Object architecture = null;
        Iterator<String> architecturesIterator = architectures.iterator();
        if (modelPlatformArchitecture == null || architectures.isEmpty() || !architecturesIterator.hasNext()) {
            return;
        }
        if (architectures.size() > 1) {
            throw new IllegalStateException(Strings.format((String)"ML nodes in this cluster have multiple platform architectures, but can only have one for this model ([%s]); expected [%s]; but was %s", (Object[])new Object[]{modelID, modelPlatformArchitecture, architectures}));
        }
        if (!Objects.equals(architecturesIterator.next(), modelPlatformArchitecture)) {
            throw new IllegalArgumentException(Strings.format((String)"The model being deployed ([%s]) is platform specific and incompatible with ML nodes in the cluster; expected [%s]; but was %s", (Object[])new Object[]{modelID, modelPlatformArchitecture, architectures}));
        }
    }
}

