/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.persistence;

import java.util.Locale;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthAction;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.utils.MlIndexAndAlias;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public final class AnomalyDetectorsIndex {
    private static final String RESULTS_MAPPINGS_VERSION_VARIABLE = "xpack.ml.version";
    private static final String RESOURCE_PATH = "/ml/anomalydetection/";
    public static final int RESULTS_INDEX_MAPPINGS_VERSION = 1;

    private AnomalyDetectorsIndex() {
    }

    public static String jobResultsIndexPrefix() {
        return ".ml-anomalies-";
    }

    public static String jobResultsAliasedName(String jobId) {
        return ".ml-anomalies-" + jobId;
    }

    public static String resultsWriteAlias(String jobId) {
        return ".ml-anomalies-.write-" + jobId;
    }

    public static String jobStateIndexWriteAlias() {
        return ".ml-state-write";
    }

    public static String jobStateIndexPattern() {
        return ".ml-state*";
    }

    public static void createStateIndexAndAliasIfNecessary(Client client, ClusterState state, IndexNameExpressionResolver resolver, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        MlIndexAndAlias.createIndexAndAliasIfNecessary(client, state, resolver, ".ml-state", AnomalyDetectorsIndex.jobStateIndexWriteAlias(), masterNodeTimeout, finalListener);
    }

    public static void createStateIndexAndAliasIfNecessaryAndWaitForYellow(Client client, ClusterState state, IndexNameExpressionResolver resolver, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        ActionListener stateIndexAndAliasCreated = finalListener.delegateFailureAndWrap((delegate, success) -> {
            ClusterHealthRequest request = (ClusterHealthRequest)new ClusterHealthRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexWriteAlias()}).waitForYellowStatus().masterNodeTimeout(masterNodeTimeout);
            ClientHelper.executeAsyncWithOrigin(client, "ml", ClusterHealthAction.INSTANCE, request, delegate.delegateFailureAndWrap((l, r) -> l.onResponse((Object)(!r.isTimedOut() ? 1 : 0))));
        });
        MlIndexAndAlias.createIndexAndAliasIfNecessary(client, state, resolver, ".ml-state", AnomalyDetectorsIndex.jobStateIndexWriteAlias(), masterNodeTimeout, (ActionListener<Boolean>)stateIndexAndAliasCreated);
    }

    public static String wrappedResultsMapping() {
        return String.format(Locale.ROOT, "{\n\"_doc\" : %s\n}", AnomalyDetectorsIndex.resultsMapping());
    }

    public static String resultsMapping() {
        return TemplateUtils.loadTemplate("/ml/anomalydetection/results_index_mappings.json", "8.11.0", RESULTS_MAPPINGS_VERSION_VARIABLE, Map.of("xpack.ml.managed.index.version", Integer.toString(1)));
    }
}

