/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.VocabularyConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public class TextClassificationConfig
implements NlpConfig {
    public static final String NAME = "text_classification";
    private static final ObjectParser<Builder, Void> STRICT_PARSER = TextClassificationConfig.createParser(false);
    private static final ObjectParser<Builder, Void> LENIENT_PARSER = TextClassificationConfig.createParser(true);
    private final VocabularyConfig vocabularyConfig;
    private final Tokenization tokenization;
    private final List<String> classificationLabels;
    private final int numTopClasses;
    private final String resultsField;

    public static TextClassificationConfig fromXContentStrict(XContentParser parser) {
        return ((Builder)STRICT_PARSER.apply(parser, null)).build();
    }

    public static TextClassificationConfig fromXContentLenient(XContentParser parser) {
        return ((Builder)LENIENT_PARSER.apply(parser, null)).build();
    }

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser parser = new ObjectParser(NAME, ignoreUnknownFields, Builder::new);
        parser.declareObject(Builder::setVocabularyConfig, (p, c) -> {
            if (!ignoreUnknownFields) {
                throw ExceptionsHelper.badRequestException("illegal setting [{}] on inference model creation", VOCABULARY.getPreferredName());
            }
            return VocabularyConfig.fromXContentLenient(p);
        }, VOCABULARY);
        parser.declareNamedObject(Builder::setTokenization, (p, c, n) -> (Tokenization)p.namedObject(Tokenization.class, n, (Object)ignoreUnknownFields), TOKENIZATION);
        parser.declareStringArray(Builder::setClassificationLabels, CLASSIFICATION_LABELS);
        parser.declareInt(Builder::setNumTopClasses, NUM_TOP_CLASSES);
        parser.declareString(Builder::setResultsField, RESULTS_FIELD);
        return parser;
    }

    public TextClassificationConfig(@Nullable VocabularyConfig vocabularyConfig, @Nullable Tokenization tokenization, List<String> classificationLabels, @Nullable Integer numTopClasses, @Nullable String resultsField) {
        this.vocabularyConfig = Optional.ofNullable(vocabularyConfig).orElse(new VocabularyConfig(InferenceIndexConstants.nativeDefinitionStore()));
        Tokenization tokenization2 = this.tokenization = tokenization == null ? Tokenization.createDefault() : tokenization;
        if (classificationLabels == null || classificationLabels.size() < 2) {
            throw ExceptionsHelper.badRequestException("[{}] requires at least 2 [{}]; provided {}", NAME, CLASSIFICATION_LABELS, classificationLabels);
        }
        this.classificationLabels = classificationLabels;
        this.numTopClasses = Optional.ofNullable(numTopClasses).orElse(-1);
        this.resultsField = resultsField;
    }

    public TextClassificationConfig(StreamInput in) throws IOException {
        this.vocabularyConfig = new VocabularyConfig(in);
        this.tokenization = (Tokenization)in.readNamedWriteable(Tokenization.class);
        this.classificationLabels = in.readStringCollectionAsList();
        this.numTopClasses = in.readInt();
        this.resultsField = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.vocabularyConfig.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.tokenization);
        out.writeStringCollection(this.classificationLabels);
        out.writeInt(this.numTopClasses);
        out.writeOptionalString(this.resultsField);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(VOCABULARY.getPreferredName(), (ToXContent)this.vocabularyConfig, params);
        NamedXContentObjectHelper.writeNamedObject(builder, params, TOKENIZATION.getPreferredName(), this.tokenization);
        builder.field(CLASSIFICATION_LABELS.getPreferredName(), this.classificationLabels);
        builder.field(NUM_TOP_CLASSES.getPreferredName(), this.numTopClasses);
        if (this.resultsField != null) {
            builder.field(RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public boolean isTargetTypeSupported(TargetType targetType) {
        return false;
    }

    @Override
    public MlConfigVersion getMinimalSupportedMlConfigVersion() {
        return MlConfigVersion.V_8_0_0;
    }

    @Override
    public TransportVersion getMinimalSupportedTransportVersion() {
        return TransportVersions.V_8_0_0;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextClassificationConfig that = (TextClassificationConfig)o;
        return Objects.equals(this.vocabularyConfig, that.vocabularyConfig) && Objects.equals(this.tokenization, that.tokenization) && Objects.equals(this.numTopClasses, that.numTopClasses) && Objects.equals(this.classificationLabels, that.classificationLabels) && Objects.equals(this.resultsField, that.resultsField);
    }

    public int hashCode() {
        return Objects.hash(this.vocabularyConfig, this.tokenization, this.classificationLabels, this.numTopClasses, this.resultsField);
    }

    @Override
    public VocabularyConfig getVocabularyConfig() {
        return this.vocabularyConfig;
    }

    @Override
    public Tokenization getTokenization() {
        return this.tokenization;
    }

    public List<String> getClassificationLabels() {
        return this.classificationLabels;
    }

    public int getNumTopClasses() {
        return this.numTopClasses;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public boolean isAllocateOnly() {
        return true;
    }

    public static class Builder {
        private VocabularyConfig vocabularyConfig;
        private Tokenization tokenization;
        private List<String> classificationLabels;
        private int numTopClasses;
        private String resultsField;

        Builder() {
        }

        Builder(TextClassificationConfig config) {
            this.vocabularyConfig = config.vocabularyConfig;
            this.tokenization = config.tokenization;
            this.classificationLabels = config.classificationLabels;
            this.numTopClasses = config.numTopClasses;
            this.resultsField = config.resultsField;
        }

        public Builder setVocabularyConfig(VocabularyConfig vocabularyConfig) {
            this.vocabularyConfig = vocabularyConfig;
            return this;
        }

        public Builder setTokenization(Tokenization tokenization) {
            this.tokenization = tokenization;
            return this;
        }

        public Builder setClassificationLabels(List<String> classificationLabels) {
            this.classificationLabels = classificationLabels;
            return this;
        }

        public Builder setNumTopClasses(Integer numTopClasses) {
            this.numTopClasses = numTopClasses;
            return this;
        }

        public Builder setResultsField(String resultsField) {
            this.resultsField = resultsField;
            return this;
        }

        public TextClassificationConfig build() {
            return new TextClassificationConfig(this.vocabularyConfig, this.tokenization, this.classificationLabels, this.numTopClasses, this.resultsField);
        }
    }
}

