/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationFields;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetricResult;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationParameters;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.MlEvaluationNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Classification;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.MulticlassConfusionMatrix;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.PainlessScripts;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.PerClassSingleValue;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class Accuracy
implements EvaluationMetric {
    public static final ParseField NAME = new ParseField("accuracy", new String[0]);
    static final String OVERALL_ACCURACY_AGG_NAME = "classification_overall_accuracy";
    private static final ObjectParser<Accuracy, Void> PARSER = new ObjectParser(NAME.getPreferredName(), true, Accuracy::new);
    private static final int MAX_CLASSES_CARDINALITY = 1000;
    private final MulticlassConfusionMatrix matrix;
    private final SetOnce<String> actualField = new SetOnce();
    private final SetOnce<Double> overallAccuracy = new SetOnce();
    private final SetOnce<Result> result = new SetOnce();

    public static Accuracy fromXContent(XContentParser parser) {
        return (Accuracy)PARSER.apply(parser, null);
    }

    public Accuracy() {
        this.matrix = new MulticlassConfusionMatrix(1000, NAME.getPreferredName() + "_");
    }

    public Accuracy(StreamInput in) throws IOException {
        this.matrix = new MulticlassConfusionMatrix(in);
    }

    public String getWriteableName() {
        return MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, NAME);
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public Set<String> getRequiredFields() {
        return Sets.newHashSet((Object[])new String[]{EvaluationFields.ACTUAL_FIELD.getPreferredName(), EvaluationFields.PREDICTED_FIELD.getPreferredName()});
    }

    @Override
    public final Tuple<List<AggregationBuilder>, List<PipelineAggregationBuilder>> aggs(EvaluationParameters parameters, EvaluationFields fields) {
        this.actualField.trySet((Object)fields.getActualField());
        ArrayList<ValuesSourceAggregationBuilder> aggs = new ArrayList<ValuesSourceAggregationBuilder>();
        ArrayList pipelineAggs = new ArrayList();
        if (this.overallAccuracy.get() == null) {
            Script script = PainlessScripts.buildIsEqualScript(fields.getActualField(), fields.getPredictedField());
            aggs.add(AggregationBuilders.avg((String)OVERALL_ACCURACY_AGG_NAME).script(script));
        }
        if (this.result.get() == null) {
            Tuple<List<AggregationBuilder>, List<PipelineAggregationBuilder>> matrixAggs = this.matrix.aggs(parameters, fields);
            aggs.addAll((Collection)matrixAggs.v1());
            pipelineAggs.addAll((Collection)matrixAggs.v2());
        }
        return Tuple.tuple(aggs, pipelineAggs);
    }

    @Override
    public void process(Aggregations aggs) {
        if (this.overallAccuracy.get() == null && aggs.get(OVERALL_ACCURACY_AGG_NAME) instanceof NumericMetricsAggregation.SingleValue) {
            NumericMetricsAggregation.SingleValue overallAccuracyAgg = (NumericMetricsAggregation.SingleValue)aggs.get(OVERALL_ACCURACY_AGG_NAME);
            this.overallAccuracy.set((Object)overallAccuracyAgg.value());
        }
        this.matrix.process(aggs);
        if (this.result.get() == null && this.matrix.getResult().isPresent()) {
            if (this.matrix.getResult().get().getOtherActualClassCount() > 0L) {
                throw ExceptionsHelper.badRequestException("Cannot calculate per-class accuracy. Cardinality of field [{}] is too high", this.actualField.get());
            }
            this.result.set((Object)new Result(Accuracy.computePerClassAccuracy(this.matrix.getResult().get()), (Double)this.overallAccuracy.get()));
        }
    }

    public Optional<Result> getResult() {
        return Optional.ofNullable((Result)this.result.get());
    }

    static List<PerClassSingleValue> computePerClassAccuracy(MulticlassConfusionMatrix.Result matrixResult) {
        assert (matrixResult.getOtherActualClassCount() == 0L);
        int n = matrixResult.getConfusionMatrix().size();
        long totalDocCount = matrixResult.getConfusionMatrix().stream().mapToLong(MulticlassConfusionMatrix.ActualClass::getActualClassDocCount).sum();
        ArrayList<PerClassSingleValue> classes = new ArrayList<PerClassSingleValue>(n);
        for (int i = 0; i < n; ++i) {
            String className = matrixResult.getConfusionMatrix().get(i).getActualClass();
            long correctDocCount = totalDocCount;
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                correctDocCount -= matrixResult.getConfusionMatrix().get(i).getPredictedClasses().get(j).getCount();
                correctDocCount -= matrixResult.getConfusionMatrix().get(j).getPredictedClasses().get(i).getCount();
            }
            classes.add(new PerClassSingleValue(className, (double)(correctDocCount -= matrixResult.getConfusionMatrix().get(i).getOtherPredictedClassDocCount()) / (double)totalDocCount));
        }
        return classes;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.matrix.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Accuracy that = (Accuracy)o;
        return Objects.equals(this.matrix, that.matrix);
    }

    public int hashCode() {
        return Objects.hash(this.matrix);
    }

    public static class Result
    implements EvaluationMetricResult {
        private static final ParseField CLASSES = new ParseField("classes", new String[0]);
        private static final ParseField OVERALL_ACCURACY = new ParseField("overall_accuracy", new String[0]);
        private static final ConstructingObjectParser<Result, Void> PARSER = new ConstructingObjectParser("accuracy_result", true, a -> new Result((List)a[0], (Double)a[1]));
        private final List<PerClassSingleValue> classes;
        private final double overallAccuracy;

        public static Result fromXContent(XContentParser parser) {
            return (Result)PARSER.apply(parser, null);
        }

        public Result(List<PerClassSingleValue> classes, double overallAccuracy) {
            this.classes = Collections.unmodifiableList(ExceptionsHelper.requireNonNull(classes, CLASSES));
            this.overallAccuracy = overallAccuracy;
        }

        public Result(StreamInput in) throws IOException {
            this.classes = in.readCollectionAsImmutableList(PerClassSingleValue::new);
            this.overallAccuracy = in.readDouble();
        }

        public String getWriteableName() {
            return MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, NAME);
        }

        @Override
        public String getMetricName() {
            return NAME.getPreferredName();
        }

        public List<PerClassSingleValue> getClasses() {
            return this.classes;
        }

        public double getOverallAccuracy() {
            return this.overallAccuracy;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.classes);
            out.writeDouble(this.overallAccuracy);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(CLASSES.getPreferredName(), this.classes);
            builder.field(OVERALL_ACCURACY.getPreferredName(), this.overallAccuracy);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result that = (Result)o;
            return Objects.equals(this.classes, that.classes) && this.overallAccuracy == that.overallAccuracy;
        }

        public int hashCode() {
            return Objects.hash(this.classes, this.overallAccuracy);
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), PerClassSingleValue.PARSER, CLASSES);
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), OVERALL_ACCURACY);
        }
    }
}

