/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetInferenceModelAction
extends ActionType<Response> {
    public static final GetInferenceModelAction INSTANCE = new GetInferenceModelAction();
    public static final String NAME = "cluster:admin/xpack/inference/get";

    public GetInferenceModelAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final List<ModelConfigurations> models;

        public Response(List<ModelConfigurations> models) {
            this.models = models;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ML_INFERENCE_GET_MULTIPLE_MODELS)) {
                this.models = in.readCollectionAsList(ModelConfigurations::new);
            } else {
                this.models = new ArrayList<ModelConfigurations>();
                this.models.add(new ModelConfigurations(in));
            }
        }

        public List<ModelConfigurations> getModels() {
            return this.models;
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ML_INFERENCE_GET_MULTIPLE_MODELS)) {
                out.writeCollection(this.models);
            } else {
                this.models.get(0).writeTo(out);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray("models");
            for (ModelConfigurations model : this.models) {
                if (model == null) continue;
                model.toXContent(builder, params);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.models, response.models);
        }

        public int hashCode() {
            return Objects.hash(this.models);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String modelId;
        private final TaskType taskType;

        public Request(String modelId, TaskType taskType) {
            this.modelId = Objects.requireNonNull(modelId);
            this.taskType = Objects.requireNonNull(taskType);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.modelId = in.readString();
            this.taskType = TaskType.fromStream((StreamInput)in);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public String getModelId() {
            return this.modelId;
        }

        public TaskType getTaskType() {
            return this.taskType;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.modelId);
            this.taskType.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.modelId, request.modelId) && this.taskType == request.taskType;
        }

        public int hashCode() {
            return Objects.hash(this.modelId, this.taskType);
        }
    }
}

