/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.server.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.bootstrap.ServerArgs;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.server.cli.APMJvmOptions;
import org.elasticsearch.server.cli.DefaultSystemMemoryInfo;
import org.elasticsearch.server.cli.JvmErgonomics;
import org.elasticsearch.server.cli.MachineDependentHeap;
import org.elasticsearch.server.cli.OverridableSystemMemoryInfo;
import org.elasticsearch.server.cli.SystemJvmOptions;

final class JvmOptionsParser {
    private static final Pattern PATTERN = Pattern.compile("((?<start>\\d+)(?<range>-)?(?<end>\\d+)?:)?(?<option>-.*)$");

    JvmOptionsParser() {
    }

    static List<String> determineJvmOptions(ServerArgs args, Path configDir, Path tmpDir, String envOptions) throws InterruptedException, IOException, UserException {
        JvmOptionsParser parser = new JvmOptionsParser();
        HashMap<String, String> substitutions = new HashMap<String, String>();
        substitutions.put("ES_TMPDIR", tmpDir.toString());
        substitutions.put("ES_PATH_CONF", configDir.toString());
        try {
            return parser.jvmOptions(args, configDir, tmpDir, envOptions, substitutions);
        }
        catch (JvmOptionsFileParserException e) {
            String errorMessage = String.format(Locale.ROOT, "encountered [%d] error%s parsing [%s]%s", e.invalidLines().size(), e.invalidLines().size() == 1 ? "" : "s", e.jvmOptionsFile(), System.lineSeparator());
            StringBuilder msg = new StringBuilder(errorMessage);
            int count = 0;
            for (Map.Entry<Integer, String> entry : e.invalidLines().entrySet()) {
                String message = String.format(Locale.ROOT, "[%d]: encountered improperly formatted JVM option in [%s] on line number [%d]: [%s]%s", ++count, e.jvmOptionsFile(), entry.getKey(), entry.getValue(), System.lineSeparator());
                msg.append(message);
            }
            throw new UserException(78, msg.toString());
        }
    }

    private List<String> jvmOptions(ServerArgs args, Path config, Path tmpDir, String esJavaOpts, Map<String, String> substitutions) throws InterruptedException, IOException, JvmOptionsFileParserException, UserException {
        List<String> jvmOptions = this.readJvmOptionsFiles(config);
        if (esJavaOpts != null) {
            jvmOptions.addAll(Arrays.stream(esJavaOpts.split("\\s+")).filter(Predicate.not(String::isBlank)).toList());
        }
        List<String> substitutedJvmOptions = JvmOptionsParser.substitutePlaceholders(jvmOptions, Collections.unmodifiableMap(substitutions));
        MachineDependentHeap machineDependentHeap = new MachineDependentHeap(new OverridableSystemMemoryInfo(substitutedJvmOptions, new DefaultSystemMemoryInfo()));
        substitutedJvmOptions.addAll(machineDependentHeap.determineHeapSettings(config, substitutedJvmOptions));
        List<String> ergonomicJvmOptions = JvmErgonomics.choose(substitutedJvmOptions);
        List<String> systemJvmOptions = SystemJvmOptions.systemJvmOptions(args.nodeSettings());
        List<String> apmOptions = APMJvmOptions.apmJvmOptions(args.nodeSettings(), args.secrets(), args.logsDir(), tmpDir);
        ArrayList<String> finalJvmOptions = new ArrayList<String>(systemJvmOptions.size() + substitutedJvmOptions.size() + ergonomicJvmOptions.size() + apmOptions.size());
        finalJvmOptions.addAll(systemJvmOptions);
        finalJvmOptions.addAll(substitutedJvmOptions);
        finalJvmOptions.addAll(ergonomicJvmOptions);
        finalJvmOptions.addAll(apmOptions);
        return finalJvmOptions;
    }

    List<String> readJvmOptionsFiles(Path config) throws IOException, JvmOptionsFileParserException {
        ArrayList<Path> jvmOptionsFiles = new ArrayList<Path>();
        jvmOptionsFiles.add(config.resolve("jvm.options"));
        Path jvmOptionsDirectory = config.resolve("jvm.options.d");
        if (Files.isDirectory(jvmOptionsDirectory, new LinkOption[0])) {
            try (DirectoryStream<Path> jvmOptionsDirectoryStream = Files.newDirectoryStream(config.resolve("jvm.options.d"), "*.options");){
                StreamSupport.stream(jvmOptionsDirectoryStream.spliterator(), false).sorted().forEach(jvmOptionsFiles::add);
            }
        }
        ArrayList<String> jvmOptions = new ArrayList<String>();
        for (Path jvmOptionsFile : jvmOptionsFiles) {
            TreeMap<Integer, String> invalidLines = new TreeMap<Integer, String>();
            try (InputStream is = Files.newInputStream(jvmOptionsFile, new OpenOption[0]);
                 InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
                 BufferedReader br = new BufferedReader(reader);){
                JvmOptionsParser.parse(Runtime.version().feature(), br, jvmOptions::add, invalidLines::put);
            }
            if (invalidLines.isEmpty()) continue;
            throw new JvmOptionsFileParserException(jvmOptionsFile, invalidLines);
        }
        return jvmOptions;
    }

    static List<String> substitutePlaceholders(List<String> jvmOptions, Map<String, String> substitutions) {
        Map<String, String> placeholderSubstitutions = substitutions.entrySet().stream().collect(Collectors.toMap(e -> "${" + (String)e.getKey() + "}", Map.Entry::getValue));
        return jvmOptions.stream().map(jvmOption -> {
            String actualJvmOption = jvmOption;
            int start = jvmOption.indexOf("${");
            if (start >= 0 && jvmOption.indexOf(125, start) > 0) {
                for (Map.Entry placeholderSubstitution : placeholderSubstitutions.entrySet()) {
                    actualJvmOption = actualJvmOption.replace((CharSequence)placeholderSubstitution.getKey(), (CharSequence)placeholderSubstitution.getValue());
                }
            }
            return actualJvmOption;
        }).collect(Collectors.toList());
    }

    static void parse(int javaMajorVersion, BufferedReader br, JvmOptionConsumer jvmOptionConsumer, InvalidLineConsumer invalidLineConsumer) throws IOException {
        int lineNumber = 0;
        while (true) {
            String line = br.readLine();
            ++lineNumber;
            if (line == null) break;
            if (line.startsWith("#") || line.matches("\\s*")) continue;
            Matcher matcher = PATTERN.matcher(line);
            if (matcher.matches()) {
                int upper;
                int lower;
                String start = matcher.group("start");
                String end = matcher.group("end");
                if (start == null) {
                    jvmOptionConsumer.accept(line);
                    continue;
                }
                try {
                    lower = Integer.parseInt(start);
                }
                catch (NumberFormatException e) {
                    invalidLineConsumer.accept(lineNumber, line);
                    continue;
                }
                if (matcher.group("range") == null) {
                    upper = lower;
                } else if (end == null) {
                    upper = Integer.MAX_VALUE;
                } else {
                    try {
                        upper = Integer.parseInt(end);
                    }
                    catch (NumberFormatException e) {
                        invalidLineConsumer.accept(lineNumber, line);
                        continue;
                    }
                    if (upper < lower) {
                        invalidLineConsumer.accept(lineNumber, line);
                        continue;
                    }
                }
                if (lower > javaMajorVersion || javaMajorVersion > upper) continue;
                jvmOptionConsumer.accept(matcher.group("option"));
                continue;
            }
            invalidLineConsumer.accept(lineNumber, line);
        }
    }

    static class JvmOptionsFileParserException
    extends Exception {
        private final Path jvmOptionsFile;
        private final SortedMap<Integer, String> invalidLines;

        Path jvmOptionsFile() {
            return this.jvmOptionsFile;
        }

        SortedMap<Integer, String> invalidLines() {
            return this.invalidLines;
        }

        JvmOptionsFileParserException(Path jvmOptionsFile, SortedMap<Integer, String> invalidLines) {
            this.jvmOptionsFile = jvmOptionsFile;
            this.invalidLines = invalidLines;
        }
    }

    static interface JvmOptionConsumer {
        public void accept(String var1);
    }

    static interface InvalidLineConsumer {
        public void accept(int var1, String var2);
    }
}

